/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantPrivilegesToRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Grant all privileges on the account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#all_privileges GrantPrivilegesToRole#all_privileges}
    */
    readonly allPrivileges?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#id GrantPrivilegesToRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If true, the privileges will be granted on the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#on_account GrantPrivilegesToRole#on_account}
    */
    readonly onAccount?: boolean | cdktf.IResolvable;
    /**
    * The privileges to grant on the account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#privileges GrantPrivilegesToRole#privileges}
    */
    readonly privileges?: string[];
    /**
    * The fully qualified name of the role to which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#role_name GrantPrivilegesToRole#role_name}
    */
    readonly roleName: string;
    /**
    * Specifies whether the grantee can grant the privileges to other users.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#with_grant_option GrantPrivilegesToRole#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
    * on_account_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#on_account_object GrantPrivilegesToRole#on_account_object}
    */
    readonly onAccountObject?: GrantPrivilegesToRoleOnAccountObject;
    /**
    * on_schema block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#on_schema GrantPrivilegesToRole#on_schema}
    */
    readonly onSchema?: GrantPrivilegesToRoleOnSchema;
    /**
    * on_schema_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#on_schema_object GrantPrivilegesToRole#on_schema_object}
    */
    readonly onSchemaObject?: GrantPrivilegesToRoleOnSchemaObject;
}
export interface GrantPrivilegesToRoleOnAccountObject {
    /**
    * The fully qualified name of the object on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_name GrantPrivilegesToRole#object_name}
    */
    readonly objectName: string;
    /**
    * The object type of the account object on which privileges will be granted. Valid values are: USER | RESOURCE MONITOR | WAREHOUSE | DATABASE | INTEGRATION | FAILOVER GROUP | REPLICATION GROUP | EXTERNAL VOLUME
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_type GrantPrivilegesToRole#object_type}
    */
    readonly objectType: string;
}
export declare function grantPrivilegesToRoleOnAccountObjectToTerraform(struct?: GrantPrivilegesToRoleOnAccountObjectOutputReference | GrantPrivilegesToRoleOnAccountObject): any;
export declare function grantPrivilegesToRoleOnAccountObjectToHclTerraform(struct?: GrantPrivilegesToRoleOnAccountObjectOutputReference | GrantPrivilegesToRoleOnAccountObject): any;
export declare class GrantPrivilegesToRoleOnAccountObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToRoleOnAccountObject | undefined;
    set internalValue(value: GrantPrivilegesToRoleOnAccountObject | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
}
export interface GrantPrivilegesToRoleOnSchema {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#all_schemas_in_database GrantPrivilegesToRole#all_schemas_in_database}
    */
    readonly allSchemasInDatabase?: string;
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#future_schemas_in_database GrantPrivilegesToRole#future_schemas_in_database}
    */
    readonly futureSchemasInDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#schema_name GrantPrivilegesToRole#schema_name}
    */
    readonly schemaName?: string;
}
export declare function grantPrivilegesToRoleOnSchemaToTerraform(struct?: GrantPrivilegesToRoleOnSchemaOutputReference | GrantPrivilegesToRoleOnSchema): any;
export declare function grantPrivilegesToRoleOnSchemaToHclTerraform(struct?: GrantPrivilegesToRoleOnSchemaOutputReference | GrantPrivilegesToRoleOnSchema): any;
export declare class GrantPrivilegesToRoleOnSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToRoleOnSchema | undefined;
    set internalValue(value: GrantPrivilegesToRoleOnSchema | undefined);
    private _allSchemasInDatabase?;
    get allSchemasInDatabase(): string;
    set allSchemasInDatabase(value: string);
    resetAllSchemasInDatabase(): void;
    get allSchemasInDatabaseInput(): string | undefined;
    private _futureSchemasInDatabase?;
    get futureSchemasInDatabase(): string;
    set futureSchemasInDatabase(value: string);
    resetFutureSchemasInDatabase(): void;
    get futureSchemasInDatabaseInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
}
export interface GrantPrivilegesToRoleOnSchemaObjectAll {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#in_database GrantPrivilegesToRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#in_schema GrantPrivilegesToRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: ALERTS | DYNAMIC TABLES | EVENT TABLES | FILE FORMATS | FUNCTIONS | ICEBERG TABLES | PROCEDURES | SECRETS | SEQUENCES | PIPES | MASKING POLICIES | PASSWORD POLICIES | ROW ACCESS POLICIES | SESSION POLICIES | TAGS | STAGES | STREAMS | TABLES | EXTERNAL TABLES | TASKS | VIEWS | MATERIALIZED VIEWS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_type_plural GrantPrivilegesToRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToRoleOnSchemaObjectAllToTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToRoleOnSchemaObjectAll): any;
export declare function grantPrivilegesToRoleOnSchemaObjectAllToHclTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToRoleOnSchemaObjectAll): any;
export declare class GrantPrivilegesToRoleOnSchemaObjectAllOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToRoleOnSchemaObjectAll | undefined;
    set internalValue(value: GrantPrivilegesToRoleOnSchemaObjectAll | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToRoleOnSchemaObjectFuture {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#in_database GrantPrivilegesToRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#in_schema GrantPrivilegesToRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: ALERTS | DYNAMIC TABLES | EVENT TABLES | FILE FORMATS | FUNCTIONS | ICEBERG TABLES | PROCEDURES | SECRETS | SEQUENCES | PIPES | MASKING POLICIES | PASSWORD POLICIES | ROW ACCESS POLICIES | SESSION POLICIES | TAGS | STAGES | STREAMS | TABLES | EXTERNAL TABLES | TASKS | VIEWS | MATERIALIZED VIEWS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_type_plural GrantPrivilegesToRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToRoleOnSchemaObjectFutureToTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToRoleOnSchemaObjectFuture): any;
export declare function grantPrivilegesToRoleOnSchemaObjectFutureToHclTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToRoleOnSchemaObjectFuture): any;
export declare class GrantPrivilegesToRoleOnSchemaObjectFutureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToRoleOnSchemaObjectFuture | undefined;
    set internalValue(value: GrantPrivilegesToRoleOnSchemaObjectFuture | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToRoleOnSchemaObject {
    /**
    * The fully qualified name of the object on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_name GrantPrivilegesToRole#object_name}
    */
    readonly objectName?: string;
    /**
    * The object type of the schema object on which privileges will be granted. Valid values are: ALERT | DYNAMIC TABLE | EVENT TABLE | FILE FORMAT | FUNCTION | ICEBERG TABLE | PROCEDURE | SECRET | SEQUENCE | PIPE | MASKING POLICY | PASSWORD POLICY | ROW ACCESS POLICY | SESSION POLICY | TAG | STAGE | STREAM | TABLE | EXTERNAL TABLE | TASK | VIEW | MATERIALIZED VIEW
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#object_type GrantPrivilegesToRole#object_type}
    */
    readonly objectType?: string;
    /**
    * all block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#all GrantPrivilegesToRole#all}
    */
    readonly all?: GrantPrivilegesToRoleOnSchemaObjectAll;
    /**
    * future block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#future GrantPrivilegesToRole#future}
    */
    readonly future?: GrantPrivilegesToRoleOnSchemaObjectFuture;
}
export declare function grantPrivilegesToRoleOnSchemaObjectToTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectOutputReference | GrantPrivilegesToRoleOnSchemaObject): any;
export declare function grantPrivilegesToRoleOnSchemaObjectToHclTerraform(struct?: GrantPrivilegesToRoleOnSchemaObjectOutputReference | GrantPrivilegesToRoleOnSchemaObject): any;
export declare class GrantPrivilegesToRoleOnSchemaObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToRoleOnSchemaObject | undefined;
    set internalValue(value: GrantPrivilegesToRoleOnSchemaObject | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _all;
    get all(): GrantPrivilegesToRoleOnSchemaObjectAllOutputReference;
    putAll(value: GrantPrivilegesToRoleOnSchemaObjectAll): void;
    resetAll(): void;
    get allInput(): GrantPrivilegesToRoleOnSchemaObjectAll | undefined;
    private _future;
    get future(): GrantPrivilegesToRoleOnSchemaObjectFutureOutputReference;
    putFuture(value: GrantPrivilegesToRoleOnSchemaObjectFuture): void;
    resetFuture(): void;
    get futureInput(): GrantPrivilegesToRoleOnSchemaObjectFuture | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role snowflake_grant_privileges_to_role}
*/
export declare class GrantPrivilegesToRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_privileges_to_role";
    /**
    * Generates CDKTF code for importing a GrantPrivilegesToRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantPrivilegesToRole to import
    * @param importFromId The id of the existing GrantPrivilegesToRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantPrivilegesToRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/grant_privileges_to_role snowflake_grant_privileges_to_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantPrivilegesToRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantPrivilegesToRoleConfig);
    private _allPrivileges?;
    get allPrivileges(): boolean | cdktf.IResolvable;
    set allPrivileges(value: boolean | cdktf.IResolvable);
    resetAllPrivileges(): void;
    get allPrivilegesInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onAccount?;
    get onAccount(): boolean | cdktf.IResolvable;
    set onAccount(value: boolean | cdktf.IResolvable);
    resetOnAccount(): void;
    get onAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    resetPrivileges(): void;
    get privilegesInput(): string[] | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _onAccountObject;
    get onAccountObject(): GrantPrivilegesToRoleOnAccountObjectOutputReference;
    putOnAccountObject(value: GrantPrivilegesToRoleOnAccountObject): void;
    resetOnAccountObject(): void;
    get onAccountObjectInput(): GrantPrivilegesToRoleOnAccountObject | undefined;
    private _onSchema;
    get onSchema(): GrantPrivilegesToRoleOnSchemaOutputReference;
    putOnSchema(value: GrantPrivilegesToRoleOnSchema): void;
    resetOnSchema(): void;
    get onSchemaInput(): GrantPrivilegesToRoleOnSchema | undefined;
    private _onSchemaObject;
    get onSchemaObject(): GrantPrivilegesToRoleOnSchemaObjectOutputReference;
    putOnSchemaObject(value: GrantPrivilegesToRoleOnSchemaObject): void;
    resetOnSchemaObject(): void;
    get onSchemaObjectInput(): GrantPrivilegesToRoleOnSchemaObject | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
