/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#aws_external_id Stage#aws_external_id}
    */
    readonly awsExternalId?: string;
    /**
    * Specifies a comment for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#comment Stage#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the copy options for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#copy_options Stage#copy_options}
    */
    readonly copyOptions?: string;
    /**
    * Specifies the credentials for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#credentials Stage#credentials}
    */
    readonly credentials?: string;
    /**
    * The database in which to create the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#database Stage#database}
    */
    readonly database: string;
    /**
    * Specifies the directory settings for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#directory Stage#directory}
    */
    readonly directory?: string;
    /**
    * Specifies the encryption settings for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#encryption Stage#encryption}
    */
    readonly encryption?: string;
    /**
    * Specifies the file format for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#file_format Stage#file_format}
    */
    readonly fileFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#id Stage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#name Stage#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#schema Stage#schema}
    */
    readonly schema: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#snowflake_iam_user Stage#snowflake_iam_user}
    */
    readonly snowflakeIamUser?: string;
    /**
    * Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#storage_integration Stage#storage_integration}
    */
    readonly storageIntegration?: string;
    /**
    * Specifies the URL for the stage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#url Stage#url}
    */
    readonly url?: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#tag Stage#tag}
    */
    readonly tag?: StageTag[] | cdktf.IResolvable;
}
export interface StageTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#database Stage#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#name Stage#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#schema Stage#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#value Stage#value}
    */
    readonly value: string;
}
export declare function stageTagToTerraform(struct?: StageTag | cdktf.IResolvable): any;
export declare function stageTagToHclTerraform(struct?: StageTag | cdktf.IResolvable): any;
export declare class StageTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StageTag | cdktf.IResolvable | undefined;
    set internalValue(value: StageTag | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class StageTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StageTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StageTagOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage snowflake_stage}
*/
export declare class Stage extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stage";
    /**
    * Generates CDKTF code for importing a Stage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Stage to import
    * @param importFromId The id of the existing Stage that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Stage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/stage snowflake_stage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StageConfig
    */
    constructor(scope: Construct, id: string, config: StageConfig);
    private _awsExternalId?;
    get awsExternalId(): string;
    set awsExternalId(value: string);
    resetAwsExternalId(): void;
    get awsExternalIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyOptions?;
    get copyOptions(): string;
    set copyOptions(value: string);
    resetCopyOptions(): void;
    get copyOptionsInput(): string | undefined;
    private _credentials?;
    get credentials(): string;
    set credentials(value: string);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _encryption?;
    get encryption(): string;
    set encryption(value: string);
    resetEncryption(): void;
    get encryptionInput(): string | undefined;
    private _fileFormat?;
    get fileFormat(): string;
    set fileFormat(value: string);
    resetFileFormat(): void;
    get fileFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _snowflakeIamUser?;
    get snowflakeIamUser(): string;
    set snowflakeIamUser(value: string);
    resetSnowflakeIamUser(): void;
    get snowflakeIamUserInput(): string | undefined;
    private _storageIntegration?;
    get storageIntegration(): string;
    set storageIntegration(value: string);
    resetStorageIntegration(): void;
    get storageIntegrationInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _tag;
    get tag(): StageTagList;
    putTag(value: StageTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | StageTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
