/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#azure_tenant_id StorageIntegration#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#comment StorageIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#enabled StorageIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#id StorageIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#name StorageIntegration#name}
    */
    readonly name: string;
    /**
    * Explicitly limits external stages that use the integration to reference one or more storage locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#storage_allowed_locations StorageIntegration#storage_allowed_locations}
    */
    readonly storageAllowedLocations: string[];
    /**
    * "bucket-owner-full-control" Enables support for AWS access control lists (ACLs) to grant the bucket owner full control.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#storage_aws_object_acl StorageIntegration#storage_aws_object_acl}
    */
    readonly storageAwsObjectAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#storage_aws_role_arn StorageIntegration#storage_aws_role_arn}
    */
    readonly storageAwsRoleArn?: string;
    /**
    * Explicitly prohibits external stages that use the integration from referencing one or more storage locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#storage_blocked_locations StorageIntegration#storage_blocked_locations}
    */
    readonly storageBlockedLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#storage_provider StorageIntegration#storage_provider}
    */
    readonly storageProvider: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#type StorageIntegration#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration snowflake_storage_integration}
*/
export declare class StorageIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_storage_integration";
    /**
    * Generates CDKTF code for importing a StorageIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageIntegration to import
    * @param importFromId The id of the existing StorageIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/storage_integration snowflake_storage_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: StorageIntegrationConfig);
    get azureConsentUrl(): string;
    get azureMultiTenantAppName(): string;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAllowedLocations?;
    get storageAllowedLocations(): string[];
    set storageAllowedLocations(value: string[]);
    get storageAllowedLocationsInput(): string[] | undefined;
    get storageAwsExternalId(): string;
    get storageAwsIamUserArn(): string;
    private _storageAwsObjectAcl?;
    get storageAwsObjectAcl(): string;
    set storageAwsObjectAcl(value: string);
    resetStorageAwsObjectAcl(): void;
    get storageAwsObjectAclInput(): string | undefined;
    private _storageAwsRoleArn?;
    get storageAwsRoleArn(): string;
    set storageAwsRoleArn(value: string);
    resetStorageAwsRoleArn(): void;
    get storageAwsRoleArnInput(): string | undefined;
    private _storageBlockedLocations?;
    get storageBlockedLocations(): string[];
    set storageBlockedLocations(value: string[]);
    resetStorageBlockedLocations(): void;
    get storageBlockedLocationsInput(): string[] | undefined;
    get storageGcpServiceAccount(): string;
    private _storageProvider?;
    get storageProvider(): string;
    set storageProvider(value: string);
    get storageProviderInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
