/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TableConstraintConfig extends cdktf.TerraformMetaArguments {
    /**
    * Columns to use in constraint key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#columns TableConstraint#columns}
    */
    readonly columns: string[];
    /**
    * Comment for the table constraint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#comment TableConstraint#comment}
    */
    readonly comment?: string;
    /**
    * Whether the constraint is deferrable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#deferrable TableConstraint#deferrable}
    */
    readonly deferrable?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the constraint is enabled or disabled. These properties are provided for compatibility with Oracle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#enable TableConstraint#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Whether the constraint is enforced
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#enforced TableConstraint#enforced}
    */
    readonly enforced?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#id TableConstraint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the constraint is initially deferred or immediate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#initially TableConstraint#initially}
    */
    readonly initially?: string;
    /**
    * Name of constraint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#name TableConstraint#name}
    */
    readonly name: string;
    /**
    * Specifies whether a constraint in NOVALIDATE mode is taken into account during query rewrite.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#rely TableConstraint#rely}
    */
    readonly rely?: boolean | cdktf.IResolvable;
    /**
    * Idenfifier for table to create constraint on. Must be of the form Note: format must follow: "<db_name>"."<schema_name>"."<table_name>" or "<db_name>.<schema_name>.<table_name>" or "<db_name>|<schema_name>.<table_name>" (snowflake_table.my_table.id)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#table_id TableConstraint#table_id}
    */
    readonly tableId: string;
    /**
    * Type of constraint, one of 'UNIQUE', 'PRIMARY KEY', 'FOREIGN KEY', or 'NOT NULL'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#type TableConstraint#type}
    */
    readonly type: string;
    /**
    * Specifies whether to validate existing data on the table when a constraint is created. Only used in conjunction with the ENABLE property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#validate TableConstraint#validate}
    */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
    * foreign_key_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#foreign_key_properties TableConstraint#foreign_key_properties}
    */
    readonly foreignKeyProperties?: TableConstraintForeignKeyProperties;
}
export interface TableConstraintForeignKeyPropertiesReferences {
    /**
    * Columns to use in foreign key reference
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#columns TableConstraint#columns}
    */
    readonly columns: string[];
    /**
    * Name of constraint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#table_id TableConstraint#table_id}
    */
    readonly tableId: string;
}
export declare function tableConstraintForeignKeyPropertiesReferencesToTerraform(struct?: TableConstraintForeignKeyPropertiesReferencesOutputReference | TableConstraintForeignKeyPropertiesReferences): any;
export declare function tableConstraintForeignKeyPropertiesReferencesToHclTerraform(struct?: TableConstraintForeignKeyPropertiesReferencesOutputReference | TableConstraintForeignKeyPropertiesReferences): any;
export declare class TableConstraintForeignKeyPropertiesReferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TableConstraintForeignKeyPropertiesReferences | undefined;
    set internalValue(value: TableConstraintForeignKeyPropertiesReferences | undefined);
    private _columns?;
    get columns(): string[];
    set columns(value: string[]);
    get columnsInput(): string[] | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface TableConstraintForeignKeyProperties {
    /**
    * The match type for the foreign key. Not applicable for primary/unique keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#match TableConstraint#match}
    */
    readonly match?: string;
    /**
    * Specifies the action performed when the primary/unique key for the foreign key is deleted. Not applicable for primary/unique keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#on_delete TableConstraint#on_delete}
    */
    readonly onDelete?: string;
    /**
    * Specifies the action performed when the primary/unique key for the foreign key is updated. Not applicable for primary/unique keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#on_update TableConstraint#on_update}
    */
    readonly onUpdate?: string;
    /**
    * references block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#references TableConstraint#references}
    */
    readonly references?: TableConstraintForeignKeyPropertiesReferences;
}
export declare function tableConstraintForeignKeyPropertiesToTerraform(struct?: TableConstraintForeignKeyPropertiesOutputReference | TableConstraintForeignKeyProperties): any;
export declare function tableConstraintForeignKeyPropertiesToHclTerraform(struct?: TableConstraintForeignKeyPropertiesOutputReference | TableConstraintForeignKeyProperties): any;
export declare class TableConstraintForeignKeyPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TableConstraintForeignKeyProperties | undefined;
    set internalValue(value: TableConstraintForeignKeyProperties | undefined);
    private _match?;
    get match(): string;
    set match(value: string);
    resetMatch(): void;
    get matchInput(): string | undefined;
    private _onDelete?;
    get onDelete(): string;
    set onDelete(value: string);
    resetOnDelete(): void;
    get onDeleteInput(): string | undefined;
    private _onUpdate?;
    get onUpdate(): string;
    set onUpdate(value: string);
    resetOnUpdate(): void;
    get onUpdateInput(): string | undefined;
    private _references;
    get references(): TableConstraintForeignKeyPropertiesReferencesOutputReference;
    putReferences(value: TableConstraintForeignKeyPropertiesReferences): void;
    resetReferences(): void;
    get referencesInput(): TableConstraintForeignKeyPropertiesReferences | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint snowflake_table_constraint}
*/
export declare class TableConstraint extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_table_constraint";
    /**
    * Generates CDKTF code for importing a TableConstraint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TableConstraint to import
    * @param importFromId The id of the existing TableConstraint that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TableConstraint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/table_constraint snowflake_table_constraint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TableConstraintConfig
    */
    constructor(scope: Construct, id: string, config: TableConstraintConfig);
    private _columns?;
    get columns(): string[];
    set columns(value: string[]);
    get columnsInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _deferrable?;
    get deferrable(): boolean | cdktf.IResolvable;
    set deferrable(value: boolean | cdktf.IResolvable);
    resetDeferrable(): void;
    get deferrableInput(): boolean | cdktf.IResolvable | undefined;
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    resetEnforced(): void;
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initially?;
    get initially(): string;
    set initially(value: string);
    resetInitially(): void;
    get initiallyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rely?;
    get rely(): boolean | cdktf.IResolvable;
    set rely(value: boolean | cdktf.IResolvable);
    resetRely(): void;
    get relyInput(): boolean | cdktf.IResolvable | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _validate?;
    get validate(): boolean | cdktf.IResolvable;
    set validate(value: boolean | cdktf.IResolvable);
    resetValidate(): void;
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _foreignKeyProperties;
    get foreignKeyProperties(): TableConstraintForeignKeyPropertiesOutputReference;
    putForeignKeyProperties(value: TableConstraintForeignKeyProperties): void;
    resetForeignKeyProperties(): void;
    get foreignKeyPropertiesInput(): TableConstraintForeignKeyProperties | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
