/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserOwnershipGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to remove or transfer all existing outbound privileges on the object when ownership is transferred to a new role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#current_grants UserOwnershipGrant#current_grants}
    */
    readonly currentGrants?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#id UserOwnershipGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the user ownership is granted on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#on_user_name UserOwnershipGrant#on_user_name}
    */
    readonly onUserName: string;
    /**
    * The name of the role to revert ownership to on destroy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#revert_ownership_to_role_name UserOwnershipGrant#revert_ownership_to_role_name}
    */
    readonly revertOwnershipToRoleName?: string;
    /**
    * The name of the role to grant ownership. Please ensure that the role that terraform is using is granted access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#to_role_name UserOwnershipGrant#to_role_name}
    */
    readonly toRoleName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant snowflake_user_ownership_grant}
*/
export declare class UserOwnershipGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_user_ownership_grant";
    /**
    * Generates CDKTF code for importing a UserOwnershipGrant resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the UserOwnershipGrant to import
    * @param importFromId The id of the existing UserOwnershipGrant that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the UserOwnershipGrant to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_ownership_grant snowflake_user_ownership_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserOwnershipGrantConfig
    */
    constructor(scope: Construct, id: string, config: UserOwnershipGrantConfig);
    private _currentGrants?;
    get currentGrants(): string;
    set currentGrants(value: string);
    resetCurrentGrants(): void;
    get currentGrantsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onUserName?;
    get onUserName(): string;
    set onUserName(value: string);
    get onUserNameInput(): string | undefined;
    private _revertOwnershipToRoleName?;
    get revertOwnershipToRoleName(): string;
    set revertOwnershipToRoleName(value: string);
    resetRevertOwnershipToRoleName(): void;
    get revertOwnershipToRoleNameInput(): string | undefined;
    private _toRoleName?;
    get toRoleName(): string;
    set toRoleName(value: string);
    get toRoleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
