/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserPublicKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys#id UserPublicKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys#name UserPublicKeys#name}
    */
    readonly name: string;
    /**
    * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys#rsa_public_key UserPublicKeys#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies the user’s second RSA public key; used to rotate the public and Public keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys#rsa_public_key_2 UserPublicKeys#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys snowflake_user_public_keys}
*/
export declare class UserPublicKeys extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_user_public_keys";
    /**
    * Generates CDKTF code for importing a UserPublicKeys resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the UserPublicKeys to import
    * @param importFromId The id of the existing UserPublicKeys that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the UserPublicKeys to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/user_public_keys snowflake_user_public_keys} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserPublicKeysConfig
    */
    constructor(scope: Construct, id: string, config: UserPublicKeysConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
