/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WarehouseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#auto_resume Warehouse#auto_resume}
    */
    readonly autoResume?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#auto_suspend Warehouse#auto_suspend}
    */
    readonly autoSuspend?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#comment Warehouse#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#enable_query_acceleration Warehouse#enable_query_acceleration}
    */
    readonly enableQueryAcceleration?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#id Warehouse#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether the warehouse is created initially in the ‘Suspended’ state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#initially_suspended Warehouse#initially_suspended}
    */
    readonly initiallySuspended?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of server clusters for the warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#max_cluster_count Warehouse#max_cluster_count}
    */
    readonly maxClusterCount?: number;
    /**
    * Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#max_concurrency_level Warehouse#max_concurrency_level}
    */
    readonly maxConcurrencyLevel?: number;
    /**
    * Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#min_cluster_count Warehouse#min_cluster_count}
    */
    readonly minClusterCount?: number;
    /**
    * Identifier for the virtual warehouse; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#name Warehouse#name}
    */
    readonly name: string;
    /**
    * Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#query_acceleration_max_scale_factor Warehouse#query_acceleration_max_scale_factor}
    */
    readonly queryAccelerationMaxScaleFactor?: number;
    /**
    * Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#resource_monitor Warehouse#resource_monitor}
    */
    readonly resourceMonitor?: string;
    /**
    * Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#scaling_policy Warehouse#scaling_policy}
    */
    readonly scalingPolicy?: string;
    /**
    * Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#statement_queued_timeout_in_seconds Warehouse#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#statement_timeout_in_seconds Warehouse#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#wait_for_provisioning Warehouse#wait_for_provisioning}
    */
    readonly waitForProvisioning?: boolean | cdktf.IResolvable;
    /**
    * Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#warehouse_size Warehouse#warehouse_size}
    */
    readonly warehouseSize?: string;
    /**
    * Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#warehouse_type Warehouse#warehouse_type}
    */
    readonly warehouseType?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse snowflake_warehouse}
*/
export declare class Warehouse extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_warehouse";
    /**
    * Generates CDKTF code for importing a Warehouse resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Warehouse to import
    * @param importFromId The id of the existing Warehouse that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Warehouse to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/warehouse snowflake_warehouse} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WarehouseConfig
    */
    constructor(scope: Construct, id: string, config: WarehouseConfig);
    private _autoResume?;
    get autoResume(): boolean | cdktf.IResolvable;
    set autoResume(value: boolean | cdktf.IResolvable);
    resetAutoResume(): void;
    get autoResumeInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSuspend?;
    get autoSuspend(): number;
    set autoSuspend(value: number);
    resetAutoSuspend(): void;
    get autoSuspendInput(): number | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _enableQueryAcceleration?;
    get enableQueryAcceleration(): boolean | cdktf.IResolvable;
    set enableQueryAcceleration(value: boolean | cdktf.IResolvable);
    resetEnableQueryAcceleration(): void;
    get enableQueryAccelerationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initiallySuspended?;
    get initiallySuspended(): boolean | cdktf.IResolvable;
    set initiallySuspended(value: boolean | cdktf.IResolvable);
    resetInitiallySuspended(): void;
    get initiallySuspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _maxClusterCount?;
    get maxClusterCount(): number;
    set maxClusterCount(value: number);
    resetMaxClusterCount(): void;
    get maxClusterCountInput(): number | undefined;
    private _maxConcurrencyLevel?;
    get maxConcurrencyLevel(): number;
    set maxConcurrencyLevel(value: number);
    resetMaxConcurrencyLevel(): void;
    get maxConcurrencyLevelInput(): number | undefined;
    private _minClusterCount?;
    get minClusterCount(): number;
    set minClusterCount(value: number);
    resetMinClusterCount(): void;
    get minClusterCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryAccelerationMaxScaleFactor?;
    get queryAccelerationMaxScaleFactor(): number;
    set queryAccelerationMaxScaleFactor(value: number);
    resetQueryAccelerationMaxScaleFactor(): void;
    get queryAccelerationMaxScaleFactorInput(): number | undefined;
    private _resourceMonitor?;
    get resourceMonitor(): string;
    set resourceMonitor(value: string);
    resetResourceMonitor(): void;
    get resourceMonitorInput(): string | undefined;
    private _scalingPolicy?;
    get scalingPolicy(): string;
    set scalingPolicy(value: string);
    resetScalingPolicy(): void;
    get scalingPolicyInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _waitForProvisioning?;
    get waitForProvisioning(): boolean | cdktf.IResolvable;
    set waitForProvisioning(value: boolean | cdktf.IResolvable);
    resetWaitForProvisioning(): void;
    get waitForProvisioningInput(): boolean | cdktf.IResolvable | undefined;
    private _warehouseSize?;
    get warehouseSize(): string;
    set warehouseSize(value: string);
    resetWarehouseSize(): void;
    get warehouseSizeInput(): string | undefined;
    private _warehouseType?;
    get warehouseType(): string;
    set warehouseType(value: string);
    resetWarehouseType(): void;
    get warehouseTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
