# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from revengai.models.callee_function_info import CalleeFunctionInfo
from revengai.models.caller_function_info import CallerFunctionInfo
from typing import Optional, Set
from typing_extensions import Self

class CalleesCallerFunctionsResponse(BaseModel):
    """
    CalleesCallerFunctionsResponse
    """ # noqa: E501
    base_address: StrictInt = Field(description="Base address of the binary")
    callees: List[CalleeFunctionInfo] = Field(description="List of functions called by the target function")
    callers: List[CallerFunctionInfo] = Field(description="List of functions that call the target function")
    __properties: ClassVar[List[str]] = ["base_address", "callees", "callers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CalleesCallerFunctionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in callees (list)
        _items = []
        if self.callees:
            for _item_callees in self.callees:
                if _item_callees:
                    _items.append(_item_callees.to_dict())
            _dict['callees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in callers (list)
        _items = []
        if self.callers:
            for _item_callers in self.callers:
                if _item_callers:
                    _items.append(_item_callers.to_dict())
            _dict['callers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CalleesCallerFunctionsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "base_address": obj.get("base_address"),
            "callees": [CalleeFunctionInfo.from_dict(_item) for _item in obj["callees"]] if obj.get("callees") is not None else None,
            "callers": [CallerFunctionInfo.from_dict(_item) for _item in obj["callers"]] if obj.get("callers") is not None else None
        })
        return _obj


