class TestPDF:
    FILLER = """
    EMUFPHZLRFAXYUSDJKZLDKRNSHGNFIVJ
    YQTQUXQBQVYUVLLTREVJYQTMKYRDMFD
    VFPJUDEEHZWETZYVGWHKKQETGFQJNCE
    GGWHKK?DQMCPFQZDQMMIAGPFXHQRLG
    TIMVMZJANQLVKQEDAGDVFRPJUNGEUNA
    QZGZLECGYUXUEENJTBJLBQCRTBJDFHRR
    YIZETKZEMVDUFKSJHKFWHKUWQLSZFTI
    HHDDDUVH?DWKBFUFPWNTDFIYCUQZERE
    EVLDKFEZMOQQJLTTUGSYQPFEUNLAVIDX
    FLGGTEZ?FKZBSFDQVGOGIPUFXHHDRKF
    FHQNTGPUAECNUVPDJMQCLQUMUNEDFQ
    ELZZVRRGKFFVOEEXBDMVPNFQXEZLGRE
    DNQFMPNZGLFLPMRJQYALMGNUVPDXVKP
    DQUMEBEDMHDAFMJGZNUPLGEWJLLAETG

    ABCDEFGHIJKLMNOPQRSTUVWXYZABCD
    AKRYPTOSABCDEFGHIJLMNQUVWXZKRYP
    BRYPTOSABCDEFGHIJLMNQUVWXZKRYPT
    CYPTOSABCDEFGHIJLMNQUVWXZKRYPTO
    DPTOSABCDEFGHIJLMNQUVWXZKRYPTOS
    ETOSABCDEFGHIJLMNQUVWXZKRYPTOSA
    FOSABCDEFGHIJLMNQUVWXZKRYPTOSAB
    GSABCDEFGHIJLMNQUVWXZKRYPTOSABC
    HABCDEFGHIJLMNQUVWXZKRYPTOSABCD
    IBCDEFGHIJLMNQUVWXZKRYPTOSABCDE
    JCDEFGHIJLMNQUVWXZKRYPTOSABCDEF
    KDEFGHIJLMNQUVWXZKRYPTOSABCDEFG
    LEFGHIJLMNQUVWXZKRYPTOSABCDEFGH
    MFGHIJLMNQUVWXZKRYPTOSABCDEFGHI

    ENDYAHROHNLSRHEOCPTEOIBIDYSHNAIA
    CHTNREYULDSLLSLLNOHSNOSMRWXMNE
    TPRNGATIHNRARPESLNNELEBLPIIACAE
    WMTWNDITEENRAHCTENEUDRETNHAEOE
    TFOLSEDTIWENHAEIOYTEYQHEENCTAYCR
    EIFTBRSPAMHHEWENATAMATEGYEERLB
    TEEFOASFIOTUETUAEOTOARMAEERTNRTI
    BSEDDNIAAHTTMSTEWPIEROAGRIEWFEB
    AECTDDHILCEIHSITEGOEAOSDDRYDLORIT
    RKLMLEHAGTDHARDPNEOHMGFMFEUHE
    ECDMRIPFEIMEHNLSSTTRTVDOHW?OBKR
    UOXOGHULBSOLIFBBWFLRVQQPRNGKSSO
    TWTQSJQSSEKZZWATJKLUDIAWINFBNYP
    VTTMZFPKWGDKZXTJCDIGKUHUAUEKCAR

    NGHIJLMNQUVWXZKRYPTOSABCDEFGHIJL
    OHIJLMNQUVWXZKRYPTOSABCDEFGHIJL
    PIJLMNQUVWXZKRYPTOSABCDEFGHIJLM
    QJLMNQUVWXZKRYPTOSABCDEFGHIJLMN
    RLMNQUVWXZKRYPTOSABCDEFGHIJLMNQ
    SMNQUVWXZKRYPTOSABCDEFGHIJLMNQU
    TNQUVWXZKRYPTOSABCDEFGHIJLMNQUV
    UQUVWXZKRYPTOSABCDEFGHIJLMNQUVW
    VUVWXZKRYPTOSABCDEFGHIJLMNQUVWX
    WVWXZKRYPTOSABCDEFGHIJLMNQUVWXZ
    XWXZKRYPTOSABCDEFGHIJLMNQUVWXZK
    YXZKRYPTOSABCDEFGHIJLMNQUVWXZKR
    ZZKRYPTOSABCDEFGHIJLMNQUVWXZKRY
    ABCDEFGHIJKLMNOPQRSTUVWXYZABCD
     """

    def __init__(self,):
        self.sharepath = './'

    def createPDF(self, name=None, size='10kb'):
        from PyPDF2 import PdfFileReader, PdfFileWriter
        from fpdf import FPDF
        import os
        import random
        name = os.path.basename(name)
        tmp_name = '/tmp/' + name
        output_name = self.sharepath + '/' + name

        if size == '10kb':
            randlength = random.randint(10000,90000)
        elif size == '100kb':
            randlength = random.randint(100000,900000)
        elif size == '1mb':
            randlength = random.randint(1000000,9000000)

        #create file
        pdf=FPDF()
        pdf.add_page()
        pdf.set_font('Arial','B',8)
        pdf.cell(0,0,os.urandom(randlength))
        pdf.output(tmp_name, "F")

        #encrypt it
        output = PdfFileWriter()
        input1 = PdfFileReader(open(tmp_name, "rb"))
        output.encrypt(user_pwd="ihasapass")
        output.addPage(input1.getPage(0))

        outputStream = file(output_name, "wb")
        output.write(outputStream)
        outputStream.close()


pdf = TestPDF()
pdf.createPDF(name='exciting.pdf', size='1mb')
