import sys
from typing import List

# Some tidy up by 6p4c and alex

# generated by a LFSR - however since it doesn't change we'll use a precomputed version.
round_keys = [
    # 0x00
    0x7ec1, 0xd36b, 0xf24a, 0x2085,
    0xf30b, 0x9a5e, 0x9457, 0x0629,
    0x9a5f, 0xd2f4, 0xa1bc, 0x3048,
    0xd7fc, 0x95a6, 0x0ae5, 0x8241,
]

final_key = 0xaf34bde6

data_keys_0 = [
    # 0x00
    0x5228, 0x170c, 0xe935, 0x79a5,
    0x9042, 0xbf60, 0x4daf, 0xca2b,
    0x8314, 0xf905, 0x697a, 0x505e,
    0x18a4, 0xcd2f, 0x4ad3, 0x85f2,
]
data_keys_1 = [
    # 0x10
    0xc120, 0x6b7e, 0x579a, 0x2994,
    0x0b06, 0x5ef3, 0xbcd2, 0x48a1,
    0x5f30, 0xf49a, 0xe595, 0x410a,
    0xfc82, 0xa6d7, 0x28af, 0x0c52,
]
data_keys_2 = [
    # 0x20
    0xe617, 0x34bd, 0x4279, 0x6090,
    0x35bf, 0xa5e9, 0x14ca, 0x0583,
    0xaff9, 0x2b4d, 0xa450, 0x2f18,
    0x7acd, 0x5e69, 0x2085, 0x7ec1,
]
data_keys_3 = [
    # 0x30
    0xd36b, 0xf24a, 0x0629, 0xf30b,
    0x9a5e, 0x9457, 0x3048, 0x9a5f,
    0xd2f4, 0xa1bc, 0x8241, 0xd7fc,
    0x95a6, 0x0ae5, 0x170c, 0xbde6,
]

def word_swap32(value: int):
    return ((value << 16) & 0xffff0000) | ((value >> 16) & 0x0000ffff)

# first run of the magic function is intialised with 0's. Further runs use the previous run as seed data
# we only run twice as 4 digit selcalls only need two bytes, but for 6 digit calls and possibly other
# features this might need to be run more times
# i think if a privacy key is set its used for a seed here?

def magic(data: List[int]=[], seed: List[int]=[0x00, 0x00, 0x00, 0x00]):
    data_seed = [a ^ b for a, b in zip(data, seed)]
    acc = int.from_bytes(data_seed, byteorder='little')

    for round_key in round_keys:
        acc ^= round_key

        temp0 = data_keys_0[(acc >> 0x4) & 0xf]
        temp1 = data_keys_1[(acc       ) & 0xf]
        temp2 = data_keys_2[(acc >> 0xc) & 0xf]
        temp3 = data_keys_3[(acc >> 0x8) & 0xf]

        key_hi = ((temp0 + temp1) ^ temp2) + temp3
        key_hi &= 0xffff

        acc ^= key_hi << 16
        
        acc = word_swap32(acc)
        
    acc ^= final_key

    acc = word_swap32(acc)

    return list(acc.to_bytes(4, byteorder='little'))


def split_bytes(data: List[int]):
    for x in data:
        yield x>>4
        yield x&0xf

# this reduces / combines the magic bytes down to two digits by spliting and merging 4 bits at a time
# while its doing this its checking if the digits are less than 10 due to it being encoded in bcd. anything
# large is skipped. since its possible to run out digits (skip too many times) we start again but minus 10
# from the digits to ensure we get enough valid values.

def to_code(data: List[int], length=2):
    output = []
    input_index = 0

    data = list(split_bytes(data))

    while len(output) < length*2: # 2 digit per byte
        a = data[input_index%8]
        
        # handle rolling over if required
        if input_index > 7:
            a = a - 10
  
        input_index += 1

        # if we aren't between 0 and 10 then we'll break BCD so skip to the next value
        if a < 10 and a >= 0:
            output.append(a)

    return [ output[x]<<4 | output[x+1] for x in range(0, len(output), 2) ] # pack two digits into a single byte


def bcd(data:int):
    return (data//0x10) * 10 + data % 0x10


def get_magic(target: int, source: int, category: int = 0x64, call_type: int = 0x7b):

    # bcd our source and target
    addr_A1 = (source//100) % 100
    addr_A2 = (source % 100)
    addr_B1 = (target//100) % 100
    addr_B2 = target % 100

    #run the magic
    first_pass = magic([call_type, addr_B1, addr_B2, category])
    second_pass = magic([addr_A1,  addr_A2, 0x00, 0x00], seed=first_pass)

    # get the magics packed
    codes = to_code(second_pass)

    # convert to bcd and return
    return (bcd(codes[0]), bcd(codes[1]))


if __name__ == "__main__":
    if len(sys.argv) == 3:
        test_magic = get_magic(int(sys.argv[1]), int(sys.argv[2]))
        print(f"{hex(test_magic[0])} {hex(test_magic[1])}")

    else:
        print("""
Usage: freeselcall.pagecall_magic 7177 1234
              """)
    