# <coded by Md Josif Khan>
import unicodedata
composite_map = {
    "ড়": "r",
    "্":"",
    "য়": "y",
    "ঢ়": "rh",
    "ওয়া":"wa",
    "ৎ": "t",
    "ু": "u"
}

bangla_to_english_map = {
    "ওয়া":"wa","অ": "a", "আ": "a", "ই": "i", "ঈ": "ei", "উ": "u", "ঊ": "u",
    "ঋ": "ri", "এ": "e", "ঐ": "oi", "ও": "w", "ঔ": "ou",
    "ক": "k", "খ": "kh", "গ": "g", "ঘ": "gh", "ঙ": "ng",
    "চ": "ch", "ছ": "ch", "জ": "j", "ঝ": "jh", "ঞ": "ny",
    "ট": "t", "ঠ": "th", "ড": "d", "ঢ": "dh", "ণ": "n",
    "ত": "t", "থ": "th", "দ": "d", "ধ": "dh", "ন": "n",
    "প": "p", "ফ": "f", "ব": "b", "ভ": "bh", "ম": "m",
    "য়": "y","য": "j", "র": "r", "ল্": "l", "ল": "l", "শ": "sh", "ষ": "sh", "স": "s", "হ": "h",
    "া": "a", "ি": "i", "ী": "i", "ু": "u", "ূ": "u",
    "ে": "e", "ৈ": "oi", "ো": "o", "ৌ": "ou",
    "ং": "ng", "ঃ": "h", "ঁ": "n",
}

def to_english(bangla_text: str) -> str:
    text = unicodedata.normalize("NFC", bangla_text)
    for comp, eng in composite_map.items():
        text = text.replace(comp, eng)
    result = "".join(bangla_to_english_map.get(ch, ch) for ch in text)
    return result.capitalize()
