"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handler = exports.TidyUp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const sfn = require("@aws-cdk/aws-stepfunctions");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
const cdk = require("@aws-cdk/core");
/**
 * The primary consruct to tidy up ECR public images.
 *
 * @stability stable
 */
class TidyUp extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        this.repository = props.repository;
        const start = new sfn.Pass(this, 'prepare repos', {
            result: sfn.Result.fromObject({
                inputForMap: props.repository,
            }),
        });
        const map = new sfn.Map(this, 'Map State', {
            maxConcurrency: props.repository.length,
            itemsPath: sfn.JsonPath.stringAt('$.inputForMap'),
            outputPath: sfn.JsonPath.stringAt('$'),
        });
        map.iterator(new tasks.LambdaInvoke(this, 'LambdaInvoke', {
            lambdaFunction: (_c = props.function) !== null && _c !== void 0 ? _c : this._addHandler().function,
            payload: sfn.TaskInput.fromObject({
                REPO: sfn.JsonPath.stringAt('$'),
            }),
        }));
        const definition = sfn.Chain.start(start)
            .next(map);
        const machine = new sfn.StateMachine(this, 'StateMachine', {
            definition,
        });
        // schedule it with event bridge
        new events.Rule(this, 'ScheduleRule', {
            schedule: (_d = props.schedule) !== null && _d !== void 0 ? _d : events.Schedule.cron({ hour: '*/4', minute: '0' }),
            targets: [new targets.SfnStateMachine(machine)],
        });
    }
    _addHandler() {
        return new Handler(this, 'TidyUpHandler', {
            repository: this.repository,
        });
    }
}
exports.TidyUp = TidyUp;
_a = JSII_RTTI_SYMBOL_1;
TidyUp[_a] = { fqn: "cdk-ecrpublic-gc.TidyUp", version: "0.1.8" };
/**
 * The default handler.
 *
 * @stability stable
 */
class Handler extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const fn = new aws_lambda_nodejs_1.NodejsFunction(this, 'Function', {
            entry: path.join(__dirname, '../lambda/main.ts'),
            handler: 'handler',
            timeout: cdk.Duration.seconds(60),
        });
        this.function = fn;
        fn.addToRolePolicy(new iam.PolicyStatement({
            actions: ['ecr-public:DescribeImages'],
            resources: ['*'],
        }));
        props.repository.forEach(r => {
            fn.addToRolePolicy(new iam.PolicyStatement({
                actions: ['ecr-public:BatchDeleteImage'],
                resources: [stack.formatArn({
                        service: 'ecr-public',
                        region: '',
                        resource: 'repository',
                        resourceName: r,
                    })],
            }));
        });
    }
}
exports.Handler = Handler;
_b = JSII_RTTI_SYMBOL_1;
Handler[_b] = { fqn: "cdk-ecrpublic-gc.Handler", version: "0.1.8" };
//# sourceMappingURL=data:application/json;base64,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