/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.ray.api.BaseActor;
import org.ray.api.id.JobId;
import org.ray.api.id.UniqueId;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.config.RayConfig;
import org.ray.runtime.context.NativeWorkerContext;
import org.ray.runtime.functionmanager.FunctionManager;
import org.ray.runtime.gcs.GcsClient;
import org.ray.runtime.gcs.GcsClientOptions;
import org.ray.runtime.gcs.RedisClient;
import org.ray.runtime.generated.Common;
import org.ray.runtime.object.NativeObjectStore;
import org.ray.runtime.runner.RunManager;
import org.ray.runtime.task.NativeTaskExecutor;
import org.ray.runtime.task.NativeTaskSubmitter;
import org.ray.runtime.task.TaskExecutor;
import org.ray.runtime.util.JniUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RayNativeRuntime
extends AbstractRayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayNativeRuntime.class);
    private RunManager manager = null;
    private long nativeCoreWorkerPointer;

    private static void resetLibraryPath(RayConfig rayConfig) {
        String separator = System.getProperty("path.separator");
        String libraryPath = String.join((CharSequence)separator, rayConfig.libraryPath);
        JniUtils.resetLibraryPath(libraryPath);
    }

    public RayNativeRuntime(RayConfig rayConfig, FunctionManager functionManager) {
        super(rayConfig, functionManager);
        RayNativeRuntime.resetLibraryPath(rayConfig);
        if (rayConfig.getRedisAddress() == null) {
            this.manager = new RunManager(rayConfig);
            this.manager.startRayProcesses(true);
        }
        this.gcsClient = new GcsClient(rayConfig.getRedisAddress(), rayConfig.redisPassword);
        if (rayConfig.getJobId() == JobId.NIL) {
            rayConfig.setJobId(this.gcsClient.nextJobId());
        }
        this.nativeCoreWorkerPointer = RayNativeRuntime.nativeInitCoreWorker(rayConfig.workerMode.getNumber(), rayConfig.objectStoreSocketName, rayConfig.rayletSocketName, rayConfig.nodeIp, rayConfig.getNodeManagerPort(), (rayConfig.workerMode == Common.WorkerType.DRIVER ? rayConfig.getJobId() : JobId.NIL).getBytes(), new GcsClientOptions(rayConfig));
        Preconditions.checkState(this.nativeCoreWorkerPointer != 0L);
        this.workerContext = new NativeWorkerContext(this.nativeCoreWorkerPointer);
        this.taskExecutor = new NativeTaskExecutor(this.nativeCoreWorkerPointer, this);
        this.objectStore = new NativeObjectStore(this.workerContext, this.nativeCoreWorkerPointer);
        this.taskSubmitter = new NativeTaskSubmitter(this.nativeCoreWorkerPointer);
        this.registerWorker();
        LOGGER.info("RayNativeRuntime started with store {}, raylet {}", (Object)rayConfig.objectStoreSocketName, (Object)rayConfig.rayletSocketName);
    }

    @Override
    public void shutdown() {
        if (this.nativeCoreWorkerPointer != 0L) {
            RayNativeRuntime.nativeDestroyCoreWorker(this.nativeCoreWorkerPointer);
            this.nativeCoreWorkerPointer = 0L;
        }
        if (null != this.manager) {
            this.manager.cleanup();
            this.manager = null;
        }
        RayConfig.reset();
        LOGGER.info("RayNativeRuntime shutdown");
    }

    public RunManager getRunManager() {
        return this.manager;
    }

    @Override
    public void setResource(String resourceName, double capacity, UniqueId nodeId) {
        Preconditions.checkArgument(Double.compare(capacity, 0.0) >= 0);
        if (nodeId == null) {
            nodeId = UniqueId.NIL;
        }
        RayNativeRuntime.nativeSetResource(this.nativeCoreWorkerPointer, resourceName, capacity, nodeId.getBytes());
    }

    @Override
    public void killActor(BaseActor actor, boolean noReconstruction) {
        RayNativeRuntime.nativeKillActor(this.nativeCoreWorkerPointer, actor.getId().getBytes(), noReconstruction);
    }

    @Override
    public Object getAsyncContext() {
        return null;
    }

    @Override
    public void setAsyncContext(Object asyncContext) {
    }

    public void run() {
        RayNativeRuntime.nativeRunTaskExecutor(this.nativeCoreWorkerPointer);
    }

    public long getNativeCoreWorkerPointer() {
        return this.nativeCoreWorkerPointer;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    private void registerWorker() {
        RedisClient redisClient = new RedisClient(this.rayConfig.getRedisAddress(), this.rayConfig.redisPassword);
        HashMap<String, String> workerInfo = new HashMap<String, String>();
        String workerId = new String(this.workerContext.getCurrentWorkerId().getBytes());
        if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
            workerInfo.put("node_ip_address", this.rayConfig.nodeIp);
            workerInfo.put("driver_id", workerId);
            workerInfo.put("start_time", String.valueOf(System.currentTimeMillis()));
            workerInfo.put("plasma_store_socket", this.rayConfig.objectStoreSocketName);
            workerInfo.put("raylet_socket", this.rayConfig.rayletSocketName);
            workerInfo.put("name", System.getProperty("user.dir"));
            redisClient.hmset("Drivers:" + workerId, workerInfo);
        } else {
            workerInfo.put("node_ip_address", this.rayConfig.nodeIp);
            workerInfo.put("plasma_store_socket", this.rayConfig.objectStoreSocketName);
            workerInfo.put("raylet_socket", this.rayConfig.rayletSocketName);
            redisClient.hmset("Workers:" + workerId, workerInfo);
        }
    }

    private static native long nativeInitCoreWorker(int var0, String var1, String var2, String var3, int var4, byte[] var5, GcsClientOptions var6);

    private static native void nativeRunTaskExecutor(long var0);

    private static native void nativeDestroyCoreWorker(long var0);

    private static native void nativeSetup(String var0, Map<String, String> var1);

    private static native void nativeShutdownHook();

    private static native void nativeSetResource(long var0, String var2, double var3, byte[] var5);

    private static native void nativeKillActor(long var0, byte[] var2, boolean var3);

    static {
        LOGGER.debug("Loading native libraries.");
        RayConfig rayConfig = RayConfig.getInstance();
        if (rayConfig.getRedisAddress() != null && rayConfig.workerMode == Common.WorkerType.DRIVER) {
            RedisClient client = new RedisClient(rayConfig.getRedisAddress(), rayConfig.redisPassword);
            String sessionDir = client.get("session_dir", null);
            Preconditions.checkNotNull(sessionDir);
            rayConfig.setSessionDir(sessionDir);
        }
        JniUtils.loadLibrary("core_worker_library_java", true);
        LOGGER.debug("Native libraries loaded.");
        RayNativeRuntime.resetLibraryPath(rayConfig);
        try {
            FileUtils.forceMkdir(new File(rayConfig.logDir));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the log directory.", e);
        }
        RayNativeRuntime.nativeSetup(rayConfig.logDir, rayConfig.rayletConfigParameters);
        Runtime.getRuntime().addShutdownHook(new Thread(RayNativeRuntime::nativeShutdownHook));
    }
}

