/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.task;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.ray.api.Checkpointable;
import org.ray.api.id.ActorId;
import org.ray.api.id.UniqueId;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.task.TaskExecutor;

public class NativeTaskExecutor
extends TaskExecutor {
    private static final int NUM_ACTOR_CHECKPOINTS_TO_KEEP = 20;
    private final long nativeCoreWorkerPointer;
    private int numTasksSinceLastCheckpoint = 0;
    private List<UniqueId> checkpointIds;
    private long lastCheckpointTimestamp = 0L;

    public NativeTaskExecutor(long nativeCoreWorkerPointer, AbstractRayRuntime runtime) {
        super(runtime);
        this.nativeCoreWorkerPointer = nativeCoreWorkerPointer;
    }

    @Override
    protected void maybeSaveCheckpoint(Object actor, ActorId actorId) {
        Checkpointable.CheckpointContext checkpointContext;
        if (!(actor instanceof Checkpointable)) {
            return;
        }
        Checkpointable checkpointable = (Checkpointable)actor;
        if (!checkpointable.shouldCheckpoint(checkpointContext = new Checkpointable.CheckpointContext(actorId, ++this.numTasksSinceLastCheckpoint, System.currentTimeMillis() - this.lastCheckpointTimestamp))) {
            return;
        }
        this.numTasksSinceLastCheckpoint = 0;
        this.lastCheckpointTimestamp = System.currentTimeMillis();
        UniqueId checkpointId = new UniqueId(NativeTaskExecutor.nativePrepareCheckpoint(this.nativeCoreWorkerPointer));
        this.checkpointIds.add(checkpointId);
        if (this.checkpointIds.size() > 20) {
            ((Checkpointable)actor).checkpointExpired(actorId, this.checkpointIds.get(0));
            this.checkpointIds.remove(0);
        }
        checkpointable.saveCheckpoint(actorId, checkpointId);
    }

    @Override
    protected void maybeLoadCheckpoint(Object actor, ActorId actorId) {
        if (!(actor instanceof Checkpointable)) {
            return;
        }
        this.numTasksSinceLastCheckpoint = 0;
        this.lastCheckpointTimestamp = System.currentTimeMillis();
        this.checkpointIds = new ArrayList<UniqueId>();
        List<Checkpointable.Checkpoint> availableCheckpoints = this.runtime.getGcsClient().getCheckpointsForActor(actorId);
        if (availableCheckpoints.isEmpty()) {
            return;
        }
        UniqueId checkpointId = ((Checkpointable)actor).loadCheckpoint(actorId, availableCheckpoints);
        if (checkpointId != null) {
            boolean checkpointValid = false;
            for (Checkpointable.Checkpoint checkpoint : availableCheckpoints) {
                if (!checkpoint.checkpointId.equals(checkpointId)) continue;
                checkpointValid = true;
                break;
            }
            Preconditions.checkArgument(checkpointValid, "'loadCheckpoint' must return a checkpoint ID that exists in the 'availableCheckpoints' list, or null.");
            NativeTaskExecutor.nativeNotifyActorResumedFromCheckpoint(this.nativeCoreWorkerPointer, checkpointId.getBytes());
        }
    }

    private static native byte[] nativePrepareCheckpoint(long var0);

    private static native void nativeNotifyActorResumedFromCheckpoint(long var0, byte[] var2);
}

