/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util;

import java.util.HashMap;
import java.util.Map;

public class ResourceUtil {
    public static final String CPU_LITERAL = "CPU";
    public static final String GPU_LITERAL = "GPU";

    public static String getResourcesStringFromMap(Map<String, Double> resources) {
        StringBuilder builder = new StringBuilder();
        if (resources != null) {
            int count = 1;
            for (Map.Entry<String, Double> entry : resources.entrySet()) {
                builder.append(entry.getKey()).append(",").append(entry.getValue());
                if (count != resources.size()) {
                    builder.append(",");
                }
                ++count;
            }
        }
        return builder.toString();
    }

    public static Map<String, Double> getResourcesMapFromString(String resources) throws IllegalArgumentException {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        if (resources != null) {
            String[] items;
            for (String item : items = resources.split(",")) {
                String trimItem = item.trim();
                if (trimItem.isEmpty()) continue;
                String[] resourcePair = trimItem.split(":");
                if (resourcePair.length != 2) {
                    throw new IllegalArgumentException("Format of static resources configure is invalid.");
                }
                String resourceName = resourcePair[0].trim();
                Double resourceValue = Double.valueOf(resourcePair[1].trim());
                ret.put(resourceName, resourceValue);
            }
        }
        return ret;
    }
}

