/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util.generator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ray.runtime.util.generator.BaseGenerator;

public class RayCallGenerator
extends BaseGenerator {
    private String generateRayCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package org.ray.api;");
        this.newLine("");
        this.newLine("import org.ray.api.function.PyActorClass;");
        this.newLine("import org.ray.api.function.PyRemoteFunction;");
        for (i = 0; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 0; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("import org.ray.api.options.ActorCreationOptions;");
        this.newLine("import org.ray.api.options.CallOptions;");
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for `Ray.call` and `Ray.createActor`.");
        this.newLine(" **/");
        this.newLine("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
        this.newLine("class RayCall {");
        this.newLine(1, "// =======================================");
        this.newLine(1, "// Methods for remote function invocation.");
        this.newLine(1, "// =======================================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, false, true, false);
            this.buildCalls(i, false, false, true, true);
            this.buildCalls(i, false, false, false, false);
            this.buildCalls(i, false, false, false, true);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Methods for actor creation.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, true, true, false);
            this.buildCalls(i, false, true, true, true);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Cross-language methods.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, false, false);
            this.buildPyCalls(i, false, false, true);
        }
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, true, false);
            this.buildPyCalls(i, false, true, true);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generateActorCallDotJava() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package org.ray.api;");
        this.newLine("");
        for (i = 1; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 1; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
        this.newLine("interface ActorCall<A> {");
        this.newLine("");
        for (i = 0; i <= 5; ++i) {
            this.buildCalls(i, true, false, true, false);
            this.buildCalls(i, true, false, false, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private String generatePyActorCallDotJava() {
        this.sb = new StringBuilder();
        this.newLine("// Generated by `RayCallGenerator.java`. DO NOT EDIT.");
        this.newLine("");
        this.newLine("package org.ray.api;");
        this.newLine("");
        this.newLine("import org.ray.api.function.PyActorMethod;");
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for remote actor calls.");
        this.newLine(" **/");
        this.newLine("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
        this.newLine("interface PyActorCall {");
        this.newLine("");
        for (int i = 0; i <= 5; ++i) {
            this.buildPyCalls(i, true, false, false);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private void buildCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasReturn, boolean hasOptionsParam) {
        String callFunc;
        String modifiers = forActor ? "default" : "public static";
        String genericTypes = "";
        for (int i = 0; i < numParameters; ++i) {
            genericTypes = genericTypes + "T" + i + ", ";
        }
        if (forActorCreation) {
            genericTypes = genericTypes + "A, ";
        } else if (hasReturn) {
            genericTypes = genericTypes + "R, ";
        }
        if (!genericTypes.isEmpty()) {
            genericTypes = genericTypes.substring(0, genericTypes.length() - 2);
            genericTypes = "<" + genericTypes + ">";
        }
        String returnType = forActorCreation ? "RayActor<A>" : (hasReturn ? "RayObject<R>" : "void");
        String rayFuncGenericTypes = genericTypes;
        if (forActor) {
            rayFuncGenericTypes = rayFuncGenericTypes.isEmpty() ? "<A>" : rayFuncGenericTypes.replace("<", "<A, ");
        }
        String argsDeclarationPrefix = String.format("RayFunc%s%d%s f, ", hasReturn ? "" : "Void", !forActor ? numParameters : numParameters + 1, rayFuncGenericTypes);
        String string = callFunc = forActorCreation ? "createActor" : "call";
        String internalCallFunc = forActorCreation ? "createActor" : (forActor ? "callActor" : "call");
        for (String param : this.generateParameters(numParameters)) {
            String argsDeclaration = argsDeclarationPrefix + param;
            if (hasOptionsParam) {
                argsDeclaration = argsDeclaration + (forActorCreation ? "ActorCreationOptions options, " : "CallOptions options, ");
            }
            argsDeclaration = argsDeclaration.substring(0, argsDeclaration.length() - 2);
            this.newLine(1, String.format("%s%s %s %s(%s) {", modifiers, genericTypes.isEmpty() ? "" : " " + genericTypes, returnType, callFunc, argsDeclaration));
            String args = "";
            for (int i = 0; i < numParameters; ++i) {
                args = args + "t" + i + ", ";
            }
            if (!args.isEmpty()) {
                args = args.substring(0, args.length() - 2);
            }
            this.newLine(2, String.format("Object[] args = new Object[]{%s};", args));
            String callFuncArgs = "";
            if (forActor) {
                callFuncArgs = callFuncArgs + "(RayActor) this, ";
            }
            callFuncArgs = callFuncArgs + "f, args, ";
            callFuncArgs = callFuncArgs + (forActor ? "" : (hasOptionsParam ? "options, " : "null, "));
            callFuncArgs = callFuncArgs.substring(0, callFuncArgs.length() - 2);
            this.newLine(2, String.format("%sRay.internal().%s(%s);", hasReturn ? "return " : "", internalCallFunc, callFuncArgs));
            this.newLine(1, "}");
            this.newLine("");
        }
    }

    private void buildPyCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasOptionsParam) {
        String funcName;
        String modifiers = forActor ? "default" : "public static";
        String argList = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            paramList = paramList + "Object obj" + i + ", ";
            argList = argList + "obj" + i + ", ";
        }
        if (argList.endsWith(", ")) {
            argList = argList.substring(0, argList.length() - 2);
        }
        if (paramList.endsWith(", ")) {
            paramList = paramList.substring(0, paramList.length() - 2);
        }
        String paramPrefix = "";
        String funcArgs = "";
        if (forActorCreation) {
            paramPrefix = paramPrefix + "PyActorClass pyActorClass";
            funcArgs = funcArgs + "pyActorClass";
        } else if (forActor) {
            paramPrefix = paramPrefix + "PyActorMethod<R> pyActorMethod";
            funcArgs = funcArgs + "pyActorMethod";
        } else {
            paramPrefix = paramPrefix + "PyRemoteFunction<R> pyRemoteFunction";
            funcArgs = funcArgs + "pyRemoteFunction";
        }
        if (numParameters > 0) {
            paramPrefix = paramPrefix + ", ";
        }
        String optionsParam = hasOptionsParam ? (forActorCreation ? ", ActorCreationOptions options" : ", CallOptions options") : "";
        String optionsArg = forActor ? "" : (hasOptionsParam ? ", options" : ", null");
        String genericType = forActorCreation ? "" : " <R>";
        String returnType = !forActorCreation ? "RayObject<R>" : "RayPyActor";
        String string = funcName = forActorCreation ? "createActor" : "call";
        String internalCallFunc = forActorCreation ? "createActor" : (forActor ? "callActor" : "call");
        funcArgs = funcArgs + ", args";
        this.newLine(1, String.format("%s%s %s %s(%s%s) {", modifiers, genericType, returnType, funcName, paramPrefix + paramList, optionsParam));
        this.newLine(2, String.format("Object[] args = new Object[]{%s};", argList));
        if (forActor) {
            this.newLine(2, String.format("return Ray.internal().%s((RayPyActor)this, %s%s);", internalCallFunc, funcArgs, optionsArg));
        } else {
            this.newLine(2, String.format("return Ray.internal().%s(%s%s);", internalCallFunc, funcArgs, optionsArg));
        }
        this.newLine(1, "}");
        this.newLine("");
    }

    private List<String> generateParameters(int numParams) {
        ArrayList<String> res = new ArrayList<String>();
        this.dfs(0, numParams, "", res);
        return res;
    }

    private void dfs(int pos, int numParams, String cur, List<String> res) {
        if (pos >= numParams) {
            res.add(cur);
            return;
        }
        String nextParameter = String.format("T%d t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
        nextParameter = String.format("RayObject<T%d> t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
    }

    public static void main(String[] args) throws IOException {
        String path = System.getProperty("user.dir") + "/api/src/main/java/org/ray/api/RayCall.java";
        FileUtils.write(new File(path), (CharSequence)new RayCallGenerator().generateRayCallDotJava(), Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/org/ray/api/ActorCall.java";
        FileUtils.write(new File(path), (CharSequence)new RayCallGenerator().generateActorCallDotJava(), Charset.defaultCharset());
        path = System.getProperty("user.dir") + "/api/src/main/java/org/ray/api/PyActorCall.java";
        FileUtils.write(new File(path), (CharSequence)new RayCallGenerator().generatePyActorCallDotJava(), Charset.defaultCharset());
    }
}

