/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.api.stream;

import java.io.Serializable;
import org.ray.streaming.api.context.StreamingContext;
import org.ray.streaming.api.partition.Partition;
import org.ray.streaming.api.partition.impl.RoundRobinPartition;
import org.ray.streaming.operator.StreamOperator;
import org.ray.streaming.python.PythonOperator;
import org.ray.streaming.python.PythonPartition;
import org.ray.streaming.python.stream.PythonStream;

public abstract class Stream<T>
implements Serializable {
    protected int id;
    protected int parallelism = 1;
    protected StreamOperator operator;
    protected Stream<T> inputStream;
    protected StreamingContext streamingContext;
    protected Partition<T> partition;

    public Stream(StreamingContext streamingContext, StreamOperator streamOperator) {
        this.streamingContext = streamingContext;
        this.operator = streamOperator;
        this.id = streamingContext.generateId();
        this.partition = streamOperator instanceof PythonOperator ? PythonPartition.RoundRobinPartition : new RoundRobinPartition();
    }

    public Stream(Stream<T> inputStream, StreamOperator streamOperator) {
        this.inputStream = inputStream;
        this.parallelism = inputStream.getParallelism();
        this.streamingContext = this.inputStream.getStreamingContext();
        this.operator = streamOperator;
        this.id = this.streamingContext.generateId();
        this.partition = this.selectPartition();
    }

    private Partition<T> selectPartition() {
        if (this.inputStream instanceof PythonStream) {
            return PythonPartition.RoundRobinPartition;
        }
        return new RoundRobinPartition();
    }

    public Stream<T> getInputStream() {
        return this.inputStream;
    }

    public StreamOperator getOperator() {
        return this.operator;
    }

    public void setOperator(StreamOperator operator) {
        this.operator = operator;
    }

    public StreamingContext getStreamingContext() {
        return this.streamingContext;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Stream<T> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public Partition<T> getPartition() {
        return this.partition;
    }

    public void setPartition(Partition<T> partition) {
        this.partition = partition;
    }
}

