/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.operator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ray.streaming.api.collector.Collector;
import org.ray.streaming.api.context.RuntimeContext;
import org.ray.streaming.api.function.impl.ReduceFunction;
import org.ray.streaming.message.KeyRecord;
import org.ray.streaming.message.Record;
import org.ray.streaming.operator.OneInputOperator;
import org.ray.streaming.operator.StreamOperator;

public class ReduceOperator<K, T>
extends StreamOperator<ReduceFunction<T>>
implements OneInputOperator<T> {
    private Map<K, T> reduceState;

    public ReduceOperator(ReduceFunction<T> reduceFunction) {
        super(reduceFunction);
    }

    @Override
    public void open(List<Collector> collectorList, RuntimeContext runtimeContext) {
        super.open(collectorList, runtimeContext);
        this.reduceState = new HashMap<K, T>();
    }

    @Override
    public void processElement(Record<T> record) throws Exception {
        KeyRecord keyRecord = (KeyRecord)record;
        Object key = keyRecord.getKey();
        Object value = keyRecord.getValue();
        if (this.reduceState.containsKey(key)) {
            T oldValue = this.reduceState.get(key);
            T newValue = ((ReduceFunction)this.function).reduce(oldValue, value);
            this.reduceState.put(key, newValue);
            this.collect(new Record<T>(newValue));
        } else {
            this.reduceState.put(key, value);
            this.collect(record);
        }
    }
}

