/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.worker.context;

import java.util.Map;
import org.ray.streaming.api.context.RuntimeContext;
import org.ray.streaming.runtime.core.graph.ExecutionTask;

public class RayRuntimeContext
implements RuntimeContext {
    private int taskId;
    private int taskIndex;
    private int parallelism;
    private Long batchId;
    private final Long maxBatch;
    private Map<String, String> config;

    public RayRuntimeContext(ExecutionTask executionTask, Map<String, String> config, int parallelism) {
        this.taskId = executionTask.getTaskId();
        this.config = config;
        this.taskIndex = executionTask.getTaskIndex();
        this.parallelism = parallelism;
        this.maxBatch = config.containsKey("streaming.batch.max.count") ? Long.valueOf(config.get("streaming.batch.max.count")) : Long.valueOf(Long.MAX_VALUE);
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public Long getBatchId() {
        return this.batchId;
    }

    @Override
    public Long getMaxBatch() {
        return this.maxBatch;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
}

