"use strict";

const { setupForSimpleEventAccessors } = require("jsdom/lib/jsdom/living/helpers/create-event-accessor");
const { fireAnEvent } = require("jsdom/lib/jsdom/living/helpers/events");
const EventTargetImpl = require("jsdom/lib/jsdom/living/events/EventTarget-impl").implementation;

class AbortSignalImpl extends EventTargetImpl {
  constructor(globalObject, args, privateData) {
    super(globalObject, args, privateData);

    // make event firing possible
    this._ownerDocument = globalObject.document;

    this.aborted = false;
    this.abortAlgorithms = new Set();
  }

  _signalAbort() {
    if (this.aborted) {
      return;
    }
    this.aborted = true;

    for (const algorithm of this.abortAlgorithms) {
      algorithm();
    }
    this.abortAlgorithms.clear();

    fireAnEvent("abort", this);
  }

  _addAlgorithm(algorithm) {
    if (this.aborted) {
      return;
    }
    this.abortAlgorithms.add(algorithm);
  }

  _removeAlgorithm(algorithm) {
    this.abortAlgorithms.delete(algorithm);
  }
}

setupForSimpleEventAccessors(AbortSignalImpl.prototype, ["abort"]);

module.exports = {
  implementation: AbortSignalImpl
};
