"use strict";
const XMLDocument = require("jsdom/lib/jsdom/living/generated/XMLDocument.js");
const Document = require("jsdom/lib/jsdom/living/generated/Document.js");
const { wrapperForImpl } = require("jsdom/lib/jsdom/living/generated/utils.js");

exports.createImpl = (globalObject, options, { alwaysUseDocumentClass = false } = {}) => {
  if (options.parsingMode === "xml" && !alwaysUseDocumentClass) {
    return XMLDocument.createImpl(globalObject, [], { options });
  }
  return Document.createImpl(globalObject, [], { options });
};

exports.createWrapper = (...args) => {
  return wrapperForImpl(exports.createImpl(...args));
};
