"use strict";

const { mixin } = require("jsdom/lib/jsdom/utils");
const EventModifierMixinImpl = require("jsdom/lib/jsdom/living/events/EventModifierMixin-impl").implementation;
const UIEventImpl = require("jsdom/lib/jsdom/living/events/UIEvent-impl").implementation;

const KeyboardEventInit = require("jsdom/lib/jsdom/living/generated/KeyboardEventInit");

class KeyboardEventImpl extends UIEventImpl {
  initKeyboardEvent(type, bubbles, cancelable, view, key, location, ctrlKey, altKey, shiftKey, metaKey) {
    if (this._dispatchFlag) {
      return;
    }

    this.initUIEvent(type, bubbles, cancelable, view, 0);
    this.key = key;
    this.location = location;
    this.ctrlKey = ctrlKey;
    this.altKey = altKey;
    this.shiftKey = shiftKey;
    this.metaKey = metaKey;
  }
}
mixin(KeyboardEventImpl.prototype, EventModifierMixinImpl.prototype);
KeyboardEventImpl.defaultInit = KeyboardEventInit.convert(undefined);

module.exports = {
  implementation: KeyboardEventImpl
};
