/* eslint-disable global-require */
"use strict";

const style = require("jsdom/lib/jsdom/level2/style");
const xpath = require("jsdom/lib/jsdom/level3/xpath");

// This object defines the mapping between the interface name and the generated interface wrapper code.
// Note: The mapping needs to stay as-is in order due to interface evaluation.
// We cannot "refactor" this to something less duplicative because that would break bundlers which depend on static
// analysis of require()s.
const generatedInterfaces = {
  DOMException: require("domexception/webidl2js-wrapper"),

  URL: require("whatwg-url/webidl2js-wrapper").URL,
  URLSearchParams: require("whatwg-url/webidl2js-wrapper").URLSearchParams,

  EventTarget: require("jsdom/lib/jsdom/living/generated/EventTarget"),

  NamedNodeMap: require("jsdom/lib/jsdom/living/generated/NamedNodeMap"),
  Node: require("jsdom/lib/jsdom/living/generated/Node"),
  Attr: require("jsdom/lib/jsdom/living/generated/Attr"),
  Element: require("jsdom/lib/jsdom/living/generated/Element"),
  DocumentFragment: require("jsdom/lib/jsdom/living/generated/DocumentFragment"),
  DOMImplementation: require("jsdom/lib/jsdom/living/generated/DOMImplementation"),
  Document: require("jsdom/lib/jsdom/living/generated/Document"),
  XMLDocument: require("jsdom/lib/jsdom/living/generated/XMLDocument"),
  CharacterData: require("jsdom/lib/jsdom/living/generated/CharacterData"),
  Text: require("jsdom/lib/jsdom/living/generated/Text"),
  CDATASection: require("jsdom/lib/jsdom/living/generated/CDATASection"),
  ProcessingInstruction: require("jsdom/lib/jsdom/living/generated/ProcessingInstruction"),
  Comment: require("jsdom/lib/jsdom/living/generated/Comment"),
  DocumentType: require("jsdom/lib/jsdom/living/generated/DocumentType"),
  NodeList: require("jsdom/lib/jsdom/living/generated/NodeList"),
  HTMLCollection: require("jsdom/lib/jsdom/living/generated/HTMLCollection"),
  HTMLOptionsCollection: require("jsdom/lib/jsdom/living/generated/HTMLOptionsCollection"),
  DOMStringMap: require("jsdom/lib/jsdom/living/generated/DOMStringMap"),
  DOMTokenList: require("jsdom/lib/jsdom/living/generated/DOMTokenList"),

  StyleSheetList: require("jsdom/lib/jsdom/living/generated/StyleSheetList.js"),

  HTMLElement: require("jsdom/lib/jsdom/living/generated/HTMLElement.js"),
  HTMLHeadElement: require("jsdom/lib/jsdom/living/generated/HTMLHeadElement.js"),
  HTMLTitleElement: require("jsdom/lib/jsdom/living/generated/HTMLTitleElement.js"),
  HTMLBaseElement: require("jsdom/lib/jsdom/living/generated/HTMLBaseElement.js"),
  HTMLLinkElement: require("jsdom/lib/jsdom/living/generated/HTMLLinkElement.js"),
  HTMLMetaElement: require("jsdom/lib/jsdom/living/generated/HTMLMetaElement.js"),
  HTMLStyleElement: require("jsdom/lib/jsdom/living/generated/HTMLStyleElement.js"),
  HTMLBodyElement: require("jsdom/lib/jsdom/living/generated/HTMLBodyElement.js"),
  HTMLHeadingElement: require("jsdom/lib/jsdom/living/generated/HTMLHeadingElement.js"),
  HTMLParagraphElement: require("jsdom/lib/jsdom/living/generated/HTMLParagraphElement.js"),
  HTMLHRElement: require("jsdom/lib/jsdom/living/generated/HTMLHRElement.js"),
  HTMLPreElement: require("jsdom/lib/jsdom/living/generated/HTMLPreElement.js"),
  HTMLUListElement: require("jsdom/lib/jsdom/living/generated/HTMLUListElement.js"),
  HTMLOListElement: require("jsdom/lib/jsdom/living/generated/HTMLOListElement.js"),
  HTMLLIElement: require("jsdom/lib/jsdom/living/generated/HTMLLIElement.js"),
  HTMLMenuElement: require("jsdom/lib/jsdom/living/generated/HTMLMenuElement.js"),
  HTMLDListElement: require("jsdom/lib/jsdom/living/generated/HTMLDListElement.js"),
  HTMLDivElement: require("jsdom/lib/jsdom/living/generated/HTMLDivElement.js"),
  HTMLAnchorElement: require("jsdom/lib/jsdom/living/generated/HTMLAnchorElement.js"),
  HTMLAreaElement: require("jsdom/lib/jsdom/living/generated/HTMLAreaElement.js"),
  HTMLBRElement: require("jsdom/lib/jsdom/living/generated/HTMLBRElement.js"),
  HTMLButtonElement: require("jsdom/lib/jsdom/living/generated/HTMLButtonElement.js"),
  HTMLCanvasElement: require("jsdom/lib/jsdom/living/generated/HTMLCanvasElement.js"),
  HTMLDataElement: require("jsdom/lib/jsdom/living/generated/HTMLDataElement.js"),
  HTMLDataListElement: require("jsdom/lib/jsdom/living/generated/HTMLDataListElement.js"),
  HTMLDetailsElement: require("jsdom/lib/jsdom/living/generated/HTMLDetailsElement.js"),
  HTMLDialogElement: require("jsdom/lib/jsdom/living/generated/HTMLDialogElement.js"),
  HTMLDirectoryElement: require("jsdom/lib/jsdom/living/generated/HTMLDirectoryElement.js"),
  HTMLFieldSetElement: require("jsdom/lib/jsdom/living/generated/HTMLFieldSetElement.js"),
  HTMLFontElement: require("jsdom/lib/jsdom/living/generated/HTMLFontElement.js"),
  HTMLFormElement: require("jsdom/lib/jsdom/living/generated/HTMLFormElement.js"),
  HTMLHtmlElement: require("jsdom/lib/jsdom/living/generated/HTMLHtmlElement.js"),
  HTMLImageElement: require("jsdom/lib/jsdom/living/generated/HTMLImageElement.js"),
  HTMLInputElement: require("jsdom/lib/jsdom/living/generated/HTMLInputElement.js"),
  HTMLLabelElement: require("jsdom/lib/jsdom/living/generated/HTMLLabelElement.js"),
  HTMLLegendElement: require("jsdom/lib/jsdom/living/generated/HTMLLegendElement.js"),
  HTMLMapElement: require("jsdom/lib/jsdom/living/generated/HTMLMapElement.js"),
  HTMLMarqueeElement: require("jsdom/lib/jsdom/living/generated/HTMLMarqueeElement.js"),
  HTMLMediaElement: require("jsdom/lib/jsdom/living/generated/HTMLMediaElement.js"),
  HTMLMeterElement: require("jsdom/lib/jsdom/living/generated/HTMLMeterElement.js"),
  HTMLModElement: require("jsdom/lib/jsdom/living/generated/HTMLModElement.js"),
  HTMLOptGroupElement: require("jsdom/lib/jsdom/living/generated/HTMLOptGroupElement.js"),
  HTMLOptionElement: require("jsdom/lib/jsdom/living/generated/HTMLOptionElement.js"),
  HTMLOutputElement: require("jsdom/lib/jsdom/living/generated/HTMLOutputElement.js"),
  HTMLPictureElement: require("jsdom/lib/jsdom/living/generated/HTMLPictureElement.js"),
  HTMLProgressElement: require("jsdom/lib/jsdom/living/generated/HTMLProgressElement.js"),
  HTMLQuoteElement: require("jsdom/lib/jsdom/living/generated/HTMLQuoteElement.js"),
  HTMLScriptElement: require("jsdom/lib/jsdom/living/generated/HTMLScriptElement.js"),
  HTMLSelectElement: require("jsdom/lib/jsdom/living/generated/HTMLSelectElement.js"),
  HTMLSlotElement: require("jsdom/lib/jsdom/living/generated/HTMLSlotElement.js"),
  HTMLSourceElement: require("jsdom/lib/jsdom/living/generated/HTMLSourceElement.js"),
  HTMLSpanElement: require("jsdom/lib/jsdom/living/generated/HTMLSpanElement.js"),
  HTMLTableCaptionElement: require("jsdom/lib/jsdom/living/generated/HTMLTableCaptionElement.js"),
  HTMLTableCellElement: require("jsdom/lib/jsdom/living/generated/HTMLTableCellElement.js"),
  HTMLTableColElement: require("jsdom/lib/jsdom/living/generated/HTMLTableColElement.js"),
  HTMLTableElement: require("jsdom/lib/jsdom/living/generated/HTMLTableElement.js"),
  HTMLTimeElement: require("jsdom/lib/jsdom/living/generated/HTMLTimeElement.js"),
  HTMLTableRowElement: require("jsdom/lib/jsdom/living/generated/HTMLTableRowElement.js"),
  HTMLTableSectionElement: require("jsdom/lib/jsdom/living/generated/HTMLTableSectionElement.js"),
  HTMLTemplateElement: require("jsdom/lib/jsdom/living/generated/HTMLTemplateElement.js"),
  HTMLTextAreaElement: require("jsdom/lib/jsdom/living/generated/HTMLTextAreaElement.js"),
  HTMLUnknownElement: require("jsdom/lib/jsdom/living/generated/HTMLUnknownElement.js"),
  HTMLFrameElement: require("jsdom/lib/jsdom/living/generated/HTMLFrameElement.js"),
  HTMLFrameSetElement: require("jsdom/lib/jsdom/living/generated/HTMLFrameSetElement.js"),
  HTMLIFrameElement: require("jsdom/lib/jsdom/living/generated/HTMLIFrameElement.js"),
  HTMLEmbedElement: require("jsdom/lib/jsdom/living/generated/HTMLEmbedElement.js"),
  HTMLObjectElement: require("jsdom/lib/jsdom/living/generated/HTMLObjectElement.js"),
  HTMLParamElement: require("jsdom/lib/jsdom/living/generated/HTMLParamElement.js"),
  HTMLVideoElement: require("jsdom/lib/jsdom/living/generated/HTMLVideoElement.js"),
  HTMLAudioElement: require("jsdom/lib/jsdom/living/generated/HTMLAudioElement.js"),
  HTMLTrackElement: require("jsdom/lib/jsdom/living/generated/HTMLTrackElement.js"),

  SVGElement: require("jsdom/lib/jsdom/living/generated/SVGElement.js"),
  SVGGraphicsElement: require("jsdom/lib/jsdom/living/generated/SVGGraphicsElement.js"),
  SVGSVGElement: require("jsdom/lib/jsdom/living/generated/SVGSVGElement.js"),
  SVGTitleElement: require("jsdom/lib/jsdom/living/generated/SVGTitleElement.js"),
  SVGAnimatedString: require("jsdom/lib/jsdom/living/generated/SVGAnimatedString"),
  SVGNumber: require("jsdom/lib/jsdom/living/generated/SVGNumber"),
  SVGStringList: require("jsdom/lib/jsdom/living/generated/SVGStringList"),

  Event: require("jsdom/lib/jsdom/living/generated/Event"),
  CloseEvent: require("jsdom/lib/jsdom/living/generated/CloseEvent"),
  CustomEvent: require("jsdom/lib/jsdom/living/generated/CustomEvent"),
  MessageEvent: require("jsdom/lib/jsdom/living/generated/MessageEvent"),
  ErrorEvent: require("jsdom/lib/jsdom/living/generated/ErrorEvent"),
  HashChangeEvent: require("jsdom/lib/jsdom/living/generated/HashChangeEvent"),
  PopStateEvent: require("jsdom/lib/jsdom/living/generated/PopStateEvent"),
  StorageEvent: require("jsdom/lib/jsdom/living/generated/StorageEvent"),
  ProgressEvent: require("jsdom/lib/jsdom/living/generated/ProgressEvent"),
  PageTransitionEvent: require("jsdom/lib/jsdom/living/generated/PageTransitionEvent"),

  UIEvent: require("jsdom/lib/jsdom/living/generated/UIEvent"),
  FocusEvent: require("jsdom/lib/jsdom/living/generated/FocusEvent"),
  InputEvent: require("jsdom/lib/jsdom/living/generated/InputEvent"),
  MouseEvent: require("jsdom/lib/jsdom/living/generated/MouseEvent"),
  KeyboardEvent: require("jsdom/lib/jsdom/living/generated/KeyboardEvent"),
  TouchEvent: require("jsdom/lib/jsdom/living/generated/TouchEvent"),
  CompositionEvent: require("jsdom/lib/jsdom/living/generated/CompositionEvent"),
  WheelEvent: require("jsdom/lib/jsdom/living/generated/WheelEvent"),

  BarProp: require("jsdom/lib/jsdom/living/generated/BarProp"),
  External: require("jsdom/lib/jsdom/living/generated/External"),
  Location: require("jsdom/lib/jsdom/living/generated/Location"),
  History: require("jsdom/lib/jsdom/living/generated/History"),
  Screen: require("jsdom/lib/jsdom/living/generated/Screen"),
  Performance: require("jsdom/lib/jsdom/living/generated/Performance"),
  Navigator: require("jsdom/lib/jsdom/living/generated/Navigator"),

  PluginArray: require("jsdom/lib/jsdom/living/generated/PluginArray"),
  MimeTypeArray: require("jsdom/lib/jsdom/living/generated/MimeTypeArray"),
  Plugin: require("jsdom/lib/jsdom/living/generated/Plugin"),
  MimeType: require("jsdom/lib/jsdom/living/generated/MimeType"),

  FileReader: require("jsdom/lib/jsdom/living/generated/FileReader"),
  Blob: require("jsdom/lib/jsdom/living/generated/Blob"),
  File: require("jsdom/lib/jsdom/living/generated/File"),
  FileList: require("jsdom/lib/jsdom/living/generated/FileList"),
  ValidityState: require("jsdom/lib/jsdom/living/generated/ValidityState"),

  DOMParser: require("jsdom/lib/jsdom/living/generated/DOMParser"),
  XMLSerializer: require("jsdom/lib/jsdom/living/generated/XMLSerializer"),

  FormData: require("jsdom/lib/jsdom/living/generated/FormData"),
  XMLHttpRequestEventTarget: require("jsdom/lib/jsdom/living/generated/XMLHttpRequestEventTarget"),
  XMLHttpRequestUpload: require("jsdom/lib/jsdom/living/generated/XMLHttpRequestUpload"),
  XMLHttpRequest: require("jsdom/lib/jsdom/living/generated/XMLHttpRequest"),
  WebSocket: require("jsdom/lib/jsdom/living/generated/WebSocket"),

  NodeFilter: require("jsdom/lib/jsdom/living/generated/NodeFilter"),
  NodeIterator: require("jsdom/lib/jsdom/living/generated/NodeIterator"),
  TreeWalker: require("jsdom/lib/jsdom/living/generated/TreeWalker"),

  AbstractRange: require("jsdom/lib/jsdom/living/generated/AbstractRange"),
  Range: require("jsdom/lib/jsdom/living/generated/Range"),
  StaticRange: require("jsdom/lib/jsdom/living/generated/StaticRange"),
  Selection: require("jsdom/lib/jsdom/living/generated/Selection"),

  Storage: require("jsdom/lib/jsdom/living/generated/Storage"),

  CustomElementRegistry: require("jsdom/lib/jsdom/living/generated/CustomElementRegistry"),
  ShadowRoot: require("jsdom/lib/jsdom/living/generated/ShadowRoot"),

  MutationObserver: require("jsdom/lib/jsdom/living/generated/MutationObserver"),
  MutationRecord: require("jsdom/lib/jsdom/living/generated/MutationRecord"),

  Headers: require("jsdom/lib/jsdom/living/generated/Headers"),
  AbortController: require("jsdom/lib/jsdom/living/generated/AbortController"),
  AbortSignal: require("jsdom/lib/jsdom/living/generated/AbortSignal")
};

function install(window, name, interfaceConstructor) {
  Object.defineProperty(window, name, {
    configurable: true,
    writable: true,
    value: interfaceConstructor
  });
}

exports.installInterfaces = (window, globalNames) => {
  // Install generated interface.
  for (const generatedInterface of Object.values(generatedInterfaces)) {
    generatedInterface.install(window, globalNames);
  }

  // Install legacy HTMLDocument interface
  // https://html.spec.whatwg.org/#htmldocument
  install(window, "HTMLDocument", window.Document);

  // These need to be cleaned up...
  style.addToCore(window);
  xpath(window);
};

// Returns an interface webidl2js wrapper given its an interface name.
exports.getInterfaceWrapper = name => {
  return generatedInterfaces[name];
};
