"use strict";
const { mixin } = require("jsdom/lib/jsdom/utils");
const NavigatorIDImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorID-impl").implementation;
const NavigatorLanguageImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorLanguage-impl").implementation;
const NavigatorOnLineImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorOnLine-impl").implementation;
const NavigatorCookiesImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorCookies-impl").implementation;
const NavigatorPluginsImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorPlugins-impl").implementation;
const NavigatorConcurrentHardwareImpl = require("jsdom/lib/jsdom/living/navigator/NavigatorConcurrentHardware-impl").implementation;

class NavigatorImpl {
  constructor(globalObject, args, privateData) {
    this._globalObject = globalObject;
    this.userAgent = privateData.userAgent;
    this.languages = Object.freeze(["en-US", "en"]);
  }
}

mixin(NavigatorImpl.prototype, NavigatorIDImpl.prototype);
mixin(NavigatorImpl.prototype, NavigatorLanguageImpl.prototype);
mixin(NavigatorImpl.prototype, NavigatorOnLineImpl.prototype);
mixin(NavigatorImpl.prototype, NavigatorCookiesImpl.prototype);
mixin(NavigatorImpl.prototype, NavigatorPluginsImpl.prototype);
mixin(NavigatorImpl.prototype, NavigatorConcurrentHardwareImpl.prototype);

exports.implementation = NavigatorImpl;
