"use strict";

const HTMLCollection = require("jsdom/lib/jsdom/living/generated/HTMLCollection");
const HTMLElementImpl = require("jsdom/lib/jsdom/living/nodes/HTMLElement-impl").implementation;

const { descendantsByLocalName } = require("jsdom/lib/jsdom/living/helpers/traversal");

class HTMLDataListElementImpl extends HTMLElementImpl {
  // https://html.spec.whatwg.org/multipage/form-elements.html#dom-datalist-options
  get options() {
    return HTMLCollection.createImpl(this._globalObject, [], {
      element: this,
      query: () => descendantsByLocalName(this, "option")
    });
  }
}

module.exports = {
  implementation: HTMLDataListElementImpl
};
