"use strict";

const HTMLElementImpl = require("jsdom/lib/jsdom/living/nodes/HTMLElement-impl").implementation;
const { childTextContent } = require("jsdom/lib/jsdom/living/helpers/text");

class HTMLTitleElementImpl extends HTMLElementImpl {
  get text() {
    return childTextContent(this);
  }

  set text(value) {
    this.textContent = value;
  }
}

module.exports = {
  implementation: HTMLTitleElementImpl
};
