"use strict";

const { mixin } = require("jsdom/lib/jsdom/utils");
const SVGNumber = require("jsdom/lib/jsdom/living/generated/SVGNumber");
const SVGGraphicsElementImpl = require("jsdom/lib/jsdom/living/nodes/SVGGraphicsElement-impl").implementation;
const WindowEventHandlersImpl = require("jsdom/lib/jsdom/living/nodes/WindowEventHandlers-impl").implementation;
const { domSymbolTree } = require("jsdom/lib/jsdom/living/helpers/internal-constants");
const { ELEMENT_NODE } = require("jsdom/lib/jsdom/living/node-type");

class SVGSVGElementImpl extends SVGGraphicsElementImpl {
  constructor(globalObject, args, privateData) {
    super(globalObject, args, privateData);
    this._proxyWindowEventsToWindow();
  }

  createSVGNumber() {
    return SVGNumber.createImpl(this._globalObject, [], {});
  }

  getElementById(elementId) {
    // TODO: optimize with _ids caching trick; see Document class.
    for (const node of domSymbolTree.treeIterator(this)) {
      if (node.nodeType === ELEMENT_NODE && node.getAttributeNS(null, "id") === elementId) {
        return node;
      }
    }
    return null;
  }

  suspendRedraw() {
    return 1;
  }
  unsuspendRedraw() {}
  unsuspendRedrawAll() {}
  forceRedraw() {}
}

mixin(SVGSVGElementImpl.prototype, WindowEventHandlersImpl.prototype);

module.exports = {
  implementation: SVGSVGElementImpl
};
