var arrayMap = require('lodash/_arrayMap'),
    copyArray = require('lodash/_copyArray'),
    isArray = require('lodash/isArray'),
    isSymbol = require('lodash/isSymbol'),
    stringToPath = require('lodash/_stringToPath'),
    toKey = require('lodash/_toKey'),
    toString = require('lodash/toString');

/**
 * Converts `value` to a property path array.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Util
 * @param {*} value The value to convert.
 * @returns {Array} Returns the new property path array.
 * @example
 *
 * _.toPath('a.b.c');
 * // => ['a', 'b', 'c']
 *
 * _.toPath('a[0].b.c');
 * // => ['a', '0', 'b', 'c']
 */
function toPath(value) {
  if (isArray(value)) {
    return arrayMap(value, toKey);
  }
  return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
}

module.exports = toPath;
