'use strict';

const ErrorReportingMixinBase = require('parse5/lib/extensions/error-reporting/mixin-base');
const PositionTrackingPreprocessorMixin = require('parse5/lib/extensions/position-tracking/preprocessor-mixin');
const Mixin = require('parse5/lib/utils/mixin');

class ErrorReportingPreprocessorMixin extends ErrorReportingMixinBase {
    constructor(preprocessor, opts) {
        super(preprocessor, opts);

        this.posTracker = Mixin.install(preprocessor, PositionTrackingPreprocessorMixin);
        this.lastErrOffset = -1;
    }

    _reportError(code) {
        //NOTE: avoid reporting error twice on advance/retreat
        if (this.lastErrOffset !== this.posTracker.offset) {
            this.lastErrOffset = this.posTracker.offset;
            super._reportError(code);
        }
    }
}

module.exports = ErrorReportingPreprocessorMixin;
