'use strict';

const ErrorReportingMixinBase = require('parse5/lib/extensions/error-reporting/mixin-base');
const ErrorReportingPreprocessorMixin = require('parse5/lib/extensions/error-reporting/preprocessor-mixin');
const Mixin = require('parse5/lib/utils/mixin');

class ErrorReportingTokenizerMixin extends ErrorReportingMixinBase {
    constructor(tokenizer, opts) {
        super(tokenizer, opts);

        const preprocessorMixin = Mixin.install(tokenizer.preprocessor, ErrorReportingPreprocessorMixin, opts);

        this.posTracker = preprocessorMixin.posTracker;
    }
}

module.exports = ErrorReportingTokenizerMixin;
