'use strict';

var TYPES = require('cssstyle/lib/parsers').TYPES;
var valueType = require('cssstyle/lib/parsers').valueType;
var shorthandParser = require('cssstyle/lib/parsers').shorthandParser;
var shorthandSetter = require('cssstyle/lib/parsers').shorthandSetter;
var shorthandGetter = require('cssstyle/lib/parsers').shorthandGetter;

var shorthand_for = {
  'font-family': require('cssstyle/lib/properties/fontFamily'),
  'font-size': require('cssstyle/lib/properties/fontSize'),
  'font-style': require('cssstyle/lib/properties/fontStyle'),
  'font-variant': require('cssstyle/lib/properties/fontVariant'),
  'font-weight': require('cssstyle/lib/properties/fontWeight'),
  'line-height': require('cssstyle/lib/properties/lineHeight'),
};

var static_fonts = [
  'caption',
  'icon',
  'menu',
  'message-box',
  'small-caption',
  'status-bar',
  'inherit',
];

var setter = shorthandSetter('font', shorthand_for);

module.exports.definition = {
  set: function(v) {
    var short = shorthandParser(v, shorthand_for);
    if (short !== undefined) {
      return setter.call(this, v);
    }
    if (valueType(v) === TYPES.KEYWORD && static_fonts.indexOf(v.toLowerCase()) !== -1) {
      this._setProperty('font', v);
    }
  },
  get: shorthandGetter('font', shorthand_for),
  enumerable: true,
  configurable: true,
};
