"use strict";
const { mixin } = require("jsdom/lib/jsdom/utils");
const { domSymbolTree } = require("jsdom/lib/jsdom/living/helpers/internal-constants");
const NODE_TYPE = require("jsdom/lib/jsdom/living/node-type");
const NodeImpl = require("jsdom/lib/jsdom/living/nodes/Node-impl").implementation;
const NonElementParentNodeImpl = require("jsdom/lib/jsdom/living/nodes/NonElementParentNode-impl").implementation;
const ParentNodeImpl = require("jsdom/lib/jsdom/living/nodes/ParentNode-impl").implementation;
const idlUtils = require("jsdom/lib/jsdom/living/generated/utils");

class DocumentFragmentImpl extends NodeImpl {
  constructor(globalObject, args, privateData) {
    super(globalObject, args, {
      ownerDocument: idlUtils.implForWrapper(globalObject._document),
      ...privateData
    });

    const { host } = privateData;
    this._host = host;

    this.nodeType = NODE_TYPE.DOCUMENT_FRAGMENT_NODE;
  }

  // This is implemented separately for Document (which has a _ids cache) and DocumentFragment (which does not).
  getElementById(id) {
    if (id === "") {
      return null;
    }

    for (const descendant of domSymbolTree.treeIterator(this)) {
      if (descendant.nodeType === NODE_TYPE.ELEMENT_NODE && descendant.getAttributeNS(null, "id") === id) {
        return descendant;
      }
    }

    return null;
  }
}

mixin(DocumentFragmentImpl.prototype, NonElementParentNodeImpl.prototype);
mixin(DocumentFragmentImpl.prototype, ParentNodeImpl.prototype);

module.exports = {
  implementation: DocumentFragmentImpl
};
