"use strict";
const { mixin } = require("jsdom/lib/jsdom/utils");
const HTMLElementImpl = require("jsdom/lib/jsdom/living/nodes/HTMLElement-impl").implementation;
const WindowEventHandlersImpl = require("jsdom/lib/jsdom/living/nodes/WindowEventHandlers-impl").implementation;

class HTMLBodyElementImpl extends HTMLElementImpl {
  constructor(...args) {
    super(...args);
    this._proxyWindowEventsToWindow();
  }
}

mixin(HTMLBodyElementImpl.prototype, WindowEventHandlersImpl.prototype);

module.exports = {
  implementation: HTMLBodyElementImpl
};
