"use strict";
const HTMLCollection = require("jsdom/lib/jsdom/living/generated/HTMLCollection");
const HTMLElementImpl = require("jsdom/lib/jsdom/living/nodes/HTMLElement-impl").implementation;
const DefaultConstraintValidationImpl =
  require("jsdom/lib/jsdom/living/constraint-validation/DefaultConstraintValidation-impl").implementation;
const { formOwner } = require("jsdom/lib/jsdom/living/helpers/form-controls");
const { mixin } = require("jsdom/lib/jsdom/utils");
const { descendantsByLocalNames } = require("jsdom/lib/jsdom/living/helpers/traversal");

const listedElements = new Set(["button", "fieldset", "input", "object", "output", "select", "textarea"]);

class HTMLFieldSetElementImpl extends HTMLElementImpl {
  constructor(globalObject, args, privateData) {
    super(globalObject, args, privateData);

    this._customValidityErrorMessage = "";
  }

  get elements() {
    return HTMLCollection.createImpl(this._globalObject, [], {
      element: this,
      query: () => descendantsByLocalNames(this, listedElements)
    });
  }

  get form() {
    return formOwner(this);
  }

  get type() {
    return "fieldset";
  }

  _barredFromConstraintValidationSpecialization() {
    return true;
  }
}

mixin(HTMLFieldSetElementImpl.prototype, DefaultConstraintValidationImpl.prototype);

module.exports = {
  implementation: HTMLFieldSetElementImpl
};
