"use strict";
const HTMLElementImpl = require("jsdom/lib/jsdom/living/nodes/HTMLElement-impl").implementation;
const DefaultConstraintValidationImpl =
  require("jsdom/lib/jsdom/living/constraint-validation/DefaultConstraintValidation-impl").implementation;
const { mixin } = require("jsdom/lib/jsdom/utils");
const { formOwner } = require("jsdom/lib/jsdom/living/helpers/form-controls");

class HTMLObjectElementImpl extends HTMLElementImpl {
  get form() {
    return formOwner(this);
  }

  get contentDocument() {
    return null;
  }

  _barredFromConstraintValidationSpecialization() {
    return true;
  }
}

mixin(HTMLObjectElementImpl.prototype, DefaultConstraintValidationImpl.prototype);

module.exports = {
  implementation: HTMLObjectElementImpl
};
