"use strict";

const { domSymbolTree } = require("jsdom/lib/jsdom/living/helpers/internal-constants");
const NODE_TYPE = require("jsdom/lib/jsdom/living/node-type");

class NonDocumentTypeChildNodeImpl {
  get nextElementSibling() {
    for (const sibling of domSymbolTree.nextSiblingsIterator(this)) {
      if (sibling.nodeType === NODE_TYPE.ELEMENT_NODE) {
        return sibling;
      }
    }
    return null;
  }

  get previousElementSibling() {
    for (const sibling of domSymbolTree.previousSiblingsIterator(this)) {
      if (sibling.nodeType === NODE_TYPE.ELEMENT_NODE) {
        return sibling;
      }
    }
    return null;
  }
}

module.exports = {
  implementation: NonDocumentTypeChildNodeImpl
};
