"use strict";

const { splitOnASCIIWhitespace, splitOnCommas } = require("jsdom/lib/jsdom/living/helpers/strings");
const { reserializeCommaSeparatedTokens, reserializeSpaceSeparatedTokens } = require("jsdom/lib/jsdom/living/helpers/svg/basic-types");
const SVGStringList = require("jsdom/lib/jsdom/living/generated/SVGStringList");

class SVGTestsImpl {
  get requiredExtensions() {
    return SVGStringList.createImpl(this._globalObject, [], {
      element: this,
      attribute: "requiredExtensions"
    });
  }

  get systemLanguage() {
    return SVGStringList.createImpl(this._globalObject, [], {
      element: this,
      attribute: "systemLanguage"
    });
  }
}

SVGTestsImpl.attributeRegistry = new Map([
  // https://svgwg.org/svg2-draft/struct.html#RequiredExtensionsAttribute
  [
    "requiredExtensions", {
      getValue: splitOnASCIIWhitespace,
      serialize: reserializeSpaceSeparatedTokens,
      initialValue: undefined
    }
  ],
  // https://svgwg.org/svg2-draft/struct.html#SystemLanguageAttribute
  [
    "systemLanguage", {
      getValue: splitOnCommas,
      serialize: reserializeCommaSeparatedTokens,
      initialValue: undefined
    }
  ]
]);

exports.implementation = SVGTestsImpl;
