"use strict";

const { parseFragment } = require("jsdom/lib/jsdom/browser/parser");
const { fragmentSerialization } = require("jsdom/lib/jsdom/living/domparsing/serialization.js");
const { nodeRoot } = require("jsdom/lib/jsdom/living/helpers/node");
const { mixin } = require("jsdom/lib/jsdom/utils");

const DocumentFragment = require("jsdom/lib/jsdom/living/nodes/DocumentFragment-impl").implementation;
const DocumentOrShadowRootImpl = require("jsdom/lib/jsdom/living/nodes/DocumentOrShadowRoot-impl").implementation;

class ShadowRootImpl extends DocumentFragment {
  constructor(globalObject, args, privateData) {
    super(globalObject, args, privateData);

    const { mode } = privateData;
    this._mode = mode;
  }

  _getTheParent(event) {
    if (!event.composed && this === nodeRoot(event._path[0].item)) {
      return null;
    }

    return this._host;
  }

  get mode() {
    return this._mode;
  }

  get host() {
    return this._host;
  }

  // https://w3c.github.io/DOM-Parsing/#dfn-innerhtml
  get innerHTML() {
    return fragmentSerialization(this, {
      requireWellFormed: true,
      globalObject: this._globalObject
    });
  }
  set innerHTML(markup) {
    const fragment = parseFragment(markup, this._host);
    this._replaceAll(fragment);
  }
}

mixin(ShadowRootImpl.prototype, DocumentOrShadowRootImpl.prototype);

module.exports = {
  implementation: ShadowRootImpl
};
