"use strict";

const { URL, URLSearchParams } = require("whatwg-url/webidl2js-wrapper");
const urlStateMachine = require("whatwg-url/lib/url-state-machine");
const urlEncoded = require("whatwg-url/lib/urlencoded");

const sharedGlobalObject = {};
URL.install(sharedGlobalObject);
URLSearchParams.install(sharedGlobalObject);

exports.URL = sharedGlobalObject.URL;
exports.URLSearchParams = sharedGlobalObject.URLSearchParams;

exports.parseURL = urlStateMachine.parseURL;
exports.basicURLParse = urlStateMachine.basicURLParse;
exports.serializeURL = urlStateMachine.serializeURL;
exports.serializeHost = urlStateMachine.serializeHost;
exports.serializeInteger = urlStateMachine.serializeInteger;
exports.serializeURLOrigin = urlStateMachine.serializeURLOrigin;
exports.setTheUsername = urlStateMachine.setTheUsername;
exports.setThePassword = urlStateMachine.setThePassword;
exports.cannotHaveAUsernamePasswordPort = urlStateMachine.cannotHaveAUsernamePasswordPort;

exports.percentDecode = urlEncoded.percentDecode;
