# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.order import Order
from toastapi.models.payment import Payment
from toastapi.models.update_payment_request import UpdatePaymentRequest

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class PaymentsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def orders_checks_payments_post(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding payments to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding payments to. ")],
        payment: Annotated[List[Payment], Field(description="An array of JSON `Payment` objects containing information about the payments you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Order:
        """Post payments

        Adds one or more payments to a check in an existing order. Include information about the payments in an array of `Payment` objects in the message body. Specify the Toast platform GUID of the order and check in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiAddingPaymentsToACheck.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding payments to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding payments to.  (required)
        :type check_guid: str
        :param payment: An array of JSON `Payment` objects containing information about the payments you are adding.  (required)
        :type payment: List[Payment]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_checks_payments_post_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment=payment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def orders_checks_payments_post_with_http_info(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding payments to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding payments to. ")],
        payment: Annotated[List[Payment], Field(description="An array of JSON `Payment` objects containing information about the payments you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Order]:
        """Post payments

        Adds one or more payments to a check in an existing order. Include information about the payments in an array of `Payment` objects in the message body. Specify the Toast platform GUID of the order and check in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiAddingPaymentsToACheck.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding payments to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding payments to.  (required)
        :type check_guid: str
        :param payment: An array of JSON `Payment` objects containing information about the payments you are adding.  (required)
        :type payment: List[Payment]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_checks_payments_post_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment=payment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def orders_checks_payments_post_without_preload_content(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are adding payments to. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are adding payments to. ")],
        payment: Annotated[List[Payment], Field(description="An array of JSON `Payment` objects containing information about the payments you are adding. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Post payments

        Adds one or more payments to a check in an existing order. Include information about the payments in an array of `Payment` objects in the message body. Specify the Toast platform GUID of the order and check in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiAddingPaymentsToACheck.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are adding payments to.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are adding payments to.  (required)
        :type check_guid: str
        :param payment: An array of JSON `Payment` objects containing information about the payments you are adding.  (required)
        :type payment: List[Payment]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_checks_payments_post_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment=payment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _orders_checks_payments_post_serialize(
        self,
        order_guid,
        check_guid,
        payment,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'Payment': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_guid is not None:
            _path_params['orderGuid'] = order_guid
        if check_guid is not None:
            _path_params['checkGuid'] = check_guid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if payment is not None:
            _body_params = payment


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def orders_order_guid_checks_check_guid_payments_payment_guid_patch(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are updating a tip in. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are updating a tip in. ")],
        payment_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the payment that you are updating a tip in. ")],
        update_payment_request: Annotated[UpdatePaymentRequest, Field(description="A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Order:
        """Update a tip amount

        Updates the tip amount in an existing payment for a check in an order. Include the new `tipAmount` value in a `Payment` object in the message body.  This endpoint does not allow any other `Payment` object value for a `PATCH` request.  Specify the Toast platform GUID of the order, check, and payment in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiUpdatingTipsInAPayment.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are updating a tip in.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are updating a tip in.  (required)
        :type check_guid: str
        :param payment_guid: The Toast platform identifier of the payment that you are updating a tip in.  (required)
        :type payment_guid: str
        :param update_payment_request: A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`.  (required)
        :type update_payment_request: UpdatePaymentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_guid_checks_check_guid_payments_payment_guid_patch_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment_guid=payment_guid,
            update_payment_request=update_payment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def orders_order_guid_checks_check_guid_payments_payment_guid_patch_with_http_info(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are updating a tip in. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are updating a tip in. ")],
        payment_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the payment that you are updating a tip in. ")],
        update_payment_request: Annotated[UpdatePaymentRequest, Field(description="A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Order]:
        """Update a tip amount

        Updates the tip amount in an existing payment for a check in an order. Include the new `tipAmount` value in a `Payment` object in the message body.  This endpoint does not allow any other `Payment` object value for a `PATCH` request.  Specify the Toast platform GUID of the order, check, and payment in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiUpdatingTipsInAPayment.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are updating a tip in.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are updating a tip in.  (required)
        :type check_guid: str
        :param payment_guid: The Toast platform identifier of the payment that you are updating a tip in.  (required)
        :type payment_guid: str
        :param update_payment_request: A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`.  (required)
        :type update_payment_request: UpdatePaymentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_guid_checks_check_guid_payments_payment_guid_patch_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment_guid=payment_guid,
            update_payment_request=update_payment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def orders_order_guid_checks_check_guid_payments_payment_guid_patch_without_preload_content(
        self,
        order_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the order that you are updating a tip in. ")],
        check_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the check that you are updating a tip in. ")],
        payment_guid: Annotated[StrictStr, Field(description="The Toast platform identifier of the payment that you are updating a tip in. ")],
        update_payment_request: Annotated[UpdatePaymentRequest, Field(description="A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a tip amount

        Updates the tip amount in an existing payment for a check in an order. Include the new `tipAmount` value in a `Payment` object in the message body.  This endpoint does not allow any other `Payment` object value for a `PATCH` request.  Specify the Toast platform GUID of the order, check, and payment in REST path parameters.  For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiUpdatingTipsInAPayment.html\"> the _Toast Developer Guide_</a>. 

        :param order_guid: The Toast platform identifier of the order that you are updating a tip in.  (required)
        :type order_guid: str
        :param check_guid: The Toast platform identifier of the check that you are updating a tip in.  (required)
        :type check_guid: str
        :param payment_guid: The Toast platform identifier of the payment that you are updating a tip in.  (required)
        :type payment_guid: str
        :param update_payment_request: A JSON `Payment` object containing the `tipAmount` value that will replace any existing tip amount for the payment.  Do not include any value other than `tipAmount`.  (required)
        :type update_payment_request: UpdatePaymentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._orders_order_guid_checks_check_guid_payments_payment_guid_patch_serialize(
            order_guid=order_guid,
            check_guid=check_guid,
            payment_guid=payment_guid,
            update_payment_request=update_payment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _orders_order_guid_checks_check_guid_payments_payment_guid_patch_serialize(
        self,
        order_guid,
        check_guid,
        payment_guid,
        update_payment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_guid is not None:
            _path_params['orderGuid'] = order_guid
        if check_guid is not None:
            _path_params['checkGuid'] = check_guid
        if payment_guid is not None:
            _path_params['paymentGuid'] = payment_guid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_payment_request is not None:
            _body_params = update_payment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments/{paymentGuid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def payments_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        paid_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        refund_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        void_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[str]:
        """Get payment identifiers

        Returns a list of the GUIDs for each payment made during one restaurant business day.  The specific hours that make up a business day depend on the business day cutoff in the restaurant configuration, which is available from the restaurants API in the `closeoutHour` property.  The business day for a restaurant is based on its local time (not UTC or local time for an API client).  You must include one of the `paidBusinessDate`, `refundBusinessDate`, or `voidBusinessDate` query parameters. 

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param paid_business_date: Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type paid_business_date: str
        :param refund_business_date: Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type refund_business_date: str
        :param void_business_date: Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type void_business_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            paid_business_date=paid_business_date,
            refund_business_date=refund_business_date,
            void_business_date=void_business_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def payments_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        paid_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        refund_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        void_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[str]]:
        """Get payment identifiers

        Returns a list of the GUIDs for each payment made during one restaurant business day.  The specific hours that make up a business day depend on the business day cutoff in the restaurant configuration, which is available from the restaurants API in the `closeoutHour` property.  The business day for a restaurant is based on its local time (not UTC or local time for an API client).  You must include one of the `paidBusinessDate`, `refundBusinessDate`, or `voidBusinessDate` query parameters. 

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param paid_business_date: Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type paid_business_date: str
        :param refund_business_date: Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type refund_business_date: str
        :param void_business_date: Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type void_business_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            paid_business_date=paid_business_date,
            refund_business_date=refund_business_date,
            void_business_date=void_business_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def payments_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        paid_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        refund_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        void_business_date: Annotated[Optional[StrictStr], Field(description="Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get payment identifiers

        Returns a list of the GUIDs for each payment made during one restaurant business day.  The specific hours that make up a business day depend on the business day cutoff in the restaurant configuration, which is available from the restaurants API in the `closeoutHour` property.  The business day for a restaurant is based on its local time (not UTC or local time for an API client).  You must include one of the `paidBusinessDate`, `refundBusinessDate`, or `voidBusinessDate` query parameters. 

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param paid_business_date: Returns a list of the payments that were made during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type paid_business_date: str
        :param refund_business_date: Returns a list of the payments that were refunded during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type refund_business_date: str
        :param void_business_date: Returns a list of the payments that were voided during one business day. Specify the business day in the format yyyyMMdd. For example, `20170101`. 
        :type void_business_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            paid_business_date=paid_business_date,
            refund_business_date=refund_business_date,
            void_business_date=void_business_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[str]",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _payments_get_serialize(
        self,
        toast_restaurant_external_id,
        paid_business_date,
        refund_business_date,
        void_business_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if paid_business_date is not None:
            
            _query_params.append(('paidBusinessDate', paid_business_date))
            
        if refund_business_date is not None:
            
            _query_params.append(('refundBusinessDate', refund_business_date))
            
        if void_business_date is not None:
            
            _query_params.append(('voidBusinessDate', void_business_date))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orders/v2/payments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def payments_guid_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        guid: Annotated[StrictStr, Field(description="The GUID for the payment you want to return.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Payment:
        """Get a payment

        Returns a JSON `Payment` object containing detailed information about a  single payment, specified by its GUID.

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param guid: The GUID for the payment you want to return. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_guid_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Payment",
            '400': None,
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def payments_guid_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        guid: Annotated[StrictStr, Field(description="The GUID for the payment you want to return.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Payment]:
        """Get a payment

        Returns a JSON `Payment` object containing detailed information about a  single payment, specified by its GUID.

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param guid: The GUID for the payment you want to return. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_guid_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Payment",
            '400': None,
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def payments_guid_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The GUID of the restaurant used as the context of the request.")],
        guid: Annotated[StrictStr, Field(description="The GUID for the payment you want to return.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a payment

        Returns a JSON `Payment` object containing detailed information about a  single payment, specified by its GUID.

        :param toast_restaurant_external_id: The GUID of the restaurant used as the context of the request. (required)
        :type toast_restaurant_external_id: str
        :param guid: The GUID for the payment you want to return. (required)
        :type guid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._payments_guid_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            guid=guid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Payment",
            '400': None,
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _payments_guid_get_serialize(
        self,
        toast_restaurant_external_id,
        guid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if guid is not None:
            _path_params['guid'] = guid
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/orders/v2/payments/{guid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


