# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.restaurant_basic import RestaurantBasic
from toastapi.models.restaurant_info import RestaurantInfo

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class RestaurantsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def groups_management_group_guid_restaurants_get(
        self,
        management_group_guid: Annotated[StrictStr, Field(description="The GUID of the restaurant management group. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of one restaurant location in the management  group. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RestaurantBasic]:
        """Get restaurants in a management group

        Returns an array of `Restaurant` objects that are a part of the  restaurant management group you specify in the  `managementGroupGUID` path parameter. Each `Restaurant` object  contains the unique Toast platform identifier for the restaurant in  its `guid` value. 

        :param management_group_guid: The GUID of the restaurant management group.  (required)
        :type management_group_guid: str
        :param toast_restaurant_external_id: The Toast GUID of one restaurant location in the management  group.  (required)
        :type toast_restaurant_external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._groups_management_group_guid_restaurants_get_serialize(
            management_group_guid=management_group_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RestaurantBasic]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def groups_management_group_guid_restaurants_get_with_http_info(
        self,
        management_group_guid: Annotated[StrictStr, Field(description="The GUID of the restaurant management group. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of one restaurant location in the management  group. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RestaurantBasic]]:
        """Get restaurants in a management group

        Returns an array of `Restaurant` objects that are a part of the  restaurant management group you specify in the  `managementGroupGUID` path parameter. Each `Restaurant` object  contains the unique Toast platform identifier for the restaurant in  its `guid` value. 

        :param management_group_guid: The GUID of the restaurant management group.  (required)
        :type management_group_guid: str
        :param toast_restaurant_external_id: The Toast GUID of one restaurant location in the management  group.  (required)
        :type toast_restaurant_external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._groups_management_group_guid_restaurants_get_serialize(
            management_group_guid=management_group_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RestaurantBasic]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def groups_management_group_guid_restaurants_get_without_preload_content(
        self,
        management_group_guid: Annotated[StrictStr, Field(description="The GUID of the restaurant management group. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of one restaurant location in the management  group. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get restaurants in a management group

        Returns an array of `Restaurant` objects that are a part of the  restaurant management group you specify in the  `managementGroupGUID` path parameter. Each `Restaurant` object  contains the unique Toast platform identifier for the restaurant in  its `guid` value. 

        :param management_group_guid: The GUID of the restaurant management group.  (required)
        :type management_group_guid: str
        :param toast_restaurant_external_id: The Toast GUID of one restaurant location in the management  group.  (required)
        :type toast_restaurant_external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._groups_management_group_guid_restaurants_get_serialize(
            management_group_guid=management_group_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RestaurantBasic]",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _groups_management_group_guid_restaurants_get_serialize(
        self,
        management_group_guid,
        toast_restaurant_external_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if management_group_guid is not None:
            _path_params['managementGroupGUID'] = management_group_guid
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/restaurants/v1/groups/{managementGroupGUID}/restaurants',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def restaurants_restaurant_guid_get(
        self,
        restaurant_guid: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        include_archived: Annotated[Optional[StrictBool], Field(description="Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RestaurantInfo:
        """Get restaurant configuration information

        Returns a `RestaurantInfo` object that contains detailed information about the configuration of a restaurant. 

        :param restaurant_guid: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type restaurant_guid: str
        :param toast_restaurant_external_id: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type toast_restaurant_external_id: str
        :param include_archived: Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restaurants_restaurant_guid_get_serialize(
            restaurant_guid=restaurant_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RestaurantInfo",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def restaurants_restaurant_guid_get_with_http_info(
        self,
        restaurant_guid: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        include_archived: Annotated[Optional[StrictBool], Field(description="Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RestaurantInfo]:
        """Get restaurant configuration information

        Returns a `RestaurantInfo` object that contains detailed information about the configuration of a restaurant. 

        :param restaurant_guid: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type restaurant_guid: str
        :param toast_restaurant_external_id: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type toast_restaurant_external_id: str
        :param include_archived: Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restaurants_restaurant_guid_get_serialize(
            restaurant_guid=restaurant_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RestaurantInfo",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def restaurants_restaurant_guid_get_without_preload_content(
        self,
        restaurant_guid: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast GUID of the restaurant that you want to get  information about. ")],
        include_archived: Annotated[Optional[StrictBool], Field(description="Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get restaurant configuration information

        Returns a `RestaurantInfo` object that contains detailed information about the configuration of a restaurant. 

        :param restaurant_guid: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type restaurant_guid: str
        :param toast_restaurant_external_id: The Toast GUID of the restaurant that you want to get  information about.  (required)
        :type toast_restaurant_external_id: str
        :param include_archived: Set `includeArchived` to `true` if the API should return information about the restaurant even if it is archived. The `General` object in the response includes an `archived` value that your integration can use to determine whether a restaurant is archived or not. A common reason for a restaurant being archived is if it was created in error. Set `includeArchived` to `false` if the API should _not_ return information about the restaurant if it is archived. Defaults to `false` if omitted. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restaurants_restaurant_guid_get_serialize(
            restaurant_guid=restaurant_guid,
            toast_restaurant_external_id=toast_restaurant_external_id,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RestaurantInfo",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _restaurants_restaurant_guid_get_serialize(
        self,
        restaurant_guid,
        toast_restaurant_external_id,
        include_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if restaurant_guid is not None:
            _path_params['restaurantGUID'] = restaurant_guid
        # process the query parameters
        if include_archived is not None:
            
            _query_params.append(('includeArchived', include_archived))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/restaurants/v1/restaurants/{restaurantGUID}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


