# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictBool, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.time_entry import TimeEntry

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class TimeEntriesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def time_entries_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_ids: Annotated[Optional[List[StrictStr]], Field(description="Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. ")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        modified_start_date: Annotated[Optional[StrictStr], Field(description="Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. ")] = None,
        modified_end_date: Annotated[Optional[StrictStr], Field(description="End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. ")] = None,
        business_date: Annotated[Optional[date], Field(description="Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. ")] = None,
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[TimeEntry]:
        """Get time entries

        Returns an array of `TimeEntry` objects that contain  information about employee shift events. The information  includes shift start times, end times, and the start and end  times of break periods.  *  Include one or more `timeEntryId` query parameters set to     the GUIDs for specific time entries.  *  Include both a `startDate` and an `endDate` query parameter     to get time entries for a specific time period.  *  Include both a `modifiedStartDate` and a `modifiedEndDate`     query parameter to get the time entries that were modified     during a specific time period.  *  Includes a `businessDate` query parameter to get the time     entries with an `inDate` during a specific business date.  Valid requests include one or more `timeEntryId` parameters,  both a `startDate` and an `endDate`, both a `modifiedStartDate`  and a `modifiedEndDate`, or a `businessDate`. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_ids: Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. 
        :type time_entry_ids: List[str]
        :param start_date: Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type start_date: str
        :param end_date: Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type end_date: str
        :param modified_start_date: Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. 
        :type modified_start_date: str
        :param modified_end_date: End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. 
        :type modified_end_date: str
        :param business_date: Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. 
        :type business_date: date
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_ids=time_entry_ids,
            start_date=start_date,
            end_date=end_date,
            modified_start_date=modified_start_date,
            modified_end_date=modified_end_date,
            business_date=business_date,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TimeEntry]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def time_entries_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_ids: Annotated[Optional[List[StrictStr]], Field(description="Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. ")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        modified_start_date: Annotated[Optional[StrictStr], Field(description="Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. ")] = None,
        modified_end_date: Annotated[Optional[StrictStr], Field(description="End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. ")] = None,
        business_date: Annotated[Optional[date], Field(description="Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. ")] = None,
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[TimeEntry]]:
        """Get time entries

        Returns an array of `TimeEntry` objects that contain  information about employee shift events. The information  includes shift start times, end times, and the start and end  times of break periods.  *  Include one or more `timeEntryId` query parameters set to     the GUIDs for specific time entries.  *  Include both a `startDate` and an `endDate` query parameter     to get time entries for a specific time period.  *  Include both a `modifiedStartDate` and a `modifiedEndDate`     query parameter to get the time entries that were modified     during a specific time period.  *  Includes a `businessDate` query parameter to get the time     entries with an `inDate` during a specific business date.  Valid requests include one or more `timeEntryId` parameters,  both a `startDate` and an `endDate`, both a `modifiedStartDate`  and a `modifiedEndDate`, or a `businessDate`. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_ids: Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. 
        :type time_entry_ids: List[str]
        :param start_date: Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type start_date: str
        :param end_date: Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type end_date: str
        :param modified_start_date: Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. 
        :type modified_start_date: str
        :param modified_end_date: End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. 
        :type modified_end_date: str
        :param business_date: Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. 
        :type business_date: date
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_ids=time_entry_ids,
            start_date=start_date,
            end_date=end_date,
            modified_start_date=modified_start_date,
            modified_end_date=modified_end_date,
            business_date=business_date,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TimeEntry]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def time_entries_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_ids: Annotated[Optional[List[StrictStr]], Field(description="Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. ")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. ")] = None,
        modified_start_date: Annotated[Optional[StrictStr], Field(description="Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. ")] = None,
        modified_end_date: Annotated[Optional[StrictStr], Field(description="End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. ")] = None,
        business_date: Annotated[Optional[date], Field(description="Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. ")] = None,
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get time entries

        Returns an array of `TimeEntry` objects that contain  information about employee shift events. The information  includes shift start times, end times, and the start and end  times of break periods.  *  Include one or more `timeEntryId` query parameters set to     the GUIDs for specific time entries.  *  Include both a `startDate` and an `endDate` query parameter     to get time entries for a specific time period.  *  Include both a `modifiedStartDate` and a `modifiedEndDate`     query parameter to get the time entries that were modified     during a specific time period.  *  Includes a `businessDate` query parameter to get the time     entries with an `inDate` during a specific business date.  Valid requests include one or more `timeEntryId` parameters,  both a `startDate` and an `endDate`, both a `modifiedStartDate`  and a `modifiedEndDate`, or a `businessDate`. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_ids: Optional array of one or more time entry identifiers,  either the Toast platform GUID or an external identifier.  100 max. 
        :type time_entry_ids: List[str]
        :param start_date: Optional start date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type start_date: str
        :param end_date: Optional end date and time of time period to match time  entries. A time entry matches the time period if its  clock-in `inDate` is after (inclusive) the specified  `startDate` and before (exclusive) the `endDate`. The  specified period cannot be longer than one month. 
        :type end_date: str
        :param modified_start_date: Start date and time of the time period to match modified  time entries. A time entry matches the time period if that  entry was modified after (inclusive) the  `modifiedStartDate`. If you include this parameter, you  must also include the `modifiedEndDate` parameter.  The  specified period cannot be longer than one month. 
        :type modified_start_date: str
        :param modified_end_date: End date and time of the time period to match modified time  entries. A time entry matches the time period if that entry  was modified before (exclusive) the `modifiedEndDate`. If  you include this parameter, you must also include the  `modifiedStartDate` parameter.  The specified period cannot  be longer than one month. 
        :type modified_end_date: str
        :param business_date: Optional date to match time entries. A time entry matches  the business date if its clock-in `inDate` is during the  business date. The cutoff from one `businessDate` to the  next is the `closeoutHour` for the restaurant. 
        :type business_date: date
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes archived time entries, when using the `startDate` and `endDate` parameters.  **Important**: this parameter _has no effect_ if you use the `modifiedStartDate` and `modifiedEndDate` parameters or the `businessDate` parameter to select time entries.  * Querying by modified date range _always_ returns archived time entries. * Querying by businessDate _never_ returns archived time entries.  This parameter is optional and the default value is `false`. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_ids=time_entry_ids,
            start_date=start_date,
            end_date=end_date,
            modified_start_date=modified_start_date,
            modified_end_date=modified_end_date,
            business_date=business_date,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TimeEntry]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _time_entries_get_serialize(
        self,
        toast_restaurant_external_id,
        time_entry_ids,
        start_date,
        end_date,
        modified_start_date,
        modified_end_date,
        business_date,
        include_missed_breaks,
        include_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'timeEntryIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if time_entry_ids is not None:
            
            _query_params.append(('timeEntryIds', time_entry_ids))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if modified_start_date is not None:
            
            _query_params.append(('modifiedStartDate', modified_start_date))
            
        if modified_end_date is not None:
            
            _query_params.append(('modifiedEndDate', modified_end_date))
            
        if business_date is not None:
            if isinstance(business_date, date):
                _query_params.append(
                    (
                        'businessDate',
                        business_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('businessDate', business_date))
            
        if include_missed_breaks is not None:
            
            _query_params.append(('includeMissedBreaks', include_missed_breaks))
            
        if include_archived is not None:
            
            _query_params.append(('includeArchived', include_archived))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/timeEntries',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def time_entries_time_entry_id_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  time entry. ")],
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes an archived time entry. Optional. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TimeEntry:
        """Get one time entry

        Returns a `TimeEntry` object containing information about one  employee shift. The information includes the shift start time,  end time, and the start and end times of break periods. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_id: The Toast platform GUID or an external identifier for the  time entry.  (required)
        :type time_entry_id: str
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes an archived time entry. Optional. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_time_entry_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_id=time_entry_id,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeEntry",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def time_entries_time_entry_id_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  time entry. ")],
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes an archived time entry. Optional. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TimeEntry]:
        """Get one time entry

        Returns a `TimeEntry` object containing information about one  employee shift. The information includes the shift start time,  end time, and the start and end times of break periods. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_id: The Toast platform GUID or an external identifier for the  time entry.  (required)
        :type time_entry_id: str
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes an archived time entry. Optional. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_time_entry_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_id=time_entry_id,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeEntry",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def time_entries_time_entry_id_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        time_entry_id: Annotated[StrictStr, Field(description="The Toast platform GUID or an external identifier for the  time entry. ")],
        include_missed_breaks: Annotated[Optional[StrictBool], Field(description="Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. ")] = None,
        include_archived: Annotated[Optional[StrictBool], Field(description="Controls whether the response includes an archived time entry. Optional. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get one time entry

        Returns a `TimeEntry` object containing information about one  employee shift. The information includes the shift start time,  end time, and the start and end times of break periods. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param time_entry_id: The Toast platform GUID or an external identifier for the  time entry.  (required)
        :type time_entry_id: str
        :param include_missed_breaks: Optional flag to indicate whether missed breaks should be  returned in the breaks array for the time entries. 
        :type include_missed_breaks: bool
        :param include_archived: Controls whether the response includes an archived time entry. Optional. 
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._time_entries_time_entry_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            time_entry_id=time_entry_id,
            include_missed_breaks=include_missed_breaks,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeEntry",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _time_entries_time_entry_id_get_serialize(
        self,
        toast_restaurant_external_id,
        time_entry_id,
        include_missed_breaks,
        include_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if time_entry_id is not None:
            _path_params['timeEntryId'] = time_entry_id
        # process the query parameters
        if include_missed_breaks is not None:
            
            _query_params.append(('includeMissedBreaks', include_missed_breaks))
            
        if include_archived is not None:
            
            _query_params.append(('includeArchived', include_archived))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/timeEntries/{timeEntryId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


