# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.toast_reference import ToastReference
from typing import Optional, Set
from typing_extensions import Self

class AppliedTaxRate(BaseModel):
    """
    A tax rate that is applied to an item or service charge.
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is.", alias="entityType")
    tax_rate: ToastReference = Field(alias="taxRate")
    name: Optional[StrictStr] = Field(default=None, description="The name of the tax rate.")
    rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The tax rate, which can be a fixed amount, a percentage, or null.")
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The tax amount that was actually applied.", alias="taxAmount")
    type: Optional[StrictStr] = Field(default=None, description="The type of the tax rate. Default is `PERCENT`.  The value `EXTERNAL` indicates that the tax is for a marketplace facilitator order, and that the marketplace facilitator organization calculated the tax amount. ")
    facilitator_collect_and_remit_tax: Optional[StrictBool] = Field(default=None, description="Indicates whether the marketplace facilitator that received a guest order remitted the tax amount on behalf of the Toast platform restaurant.  You can use this information to identify tax amounts that have already been paid by an ordering service provider and do not need to be paid again.  * `true` - The marketplace facilitator paid the tax amount on behalf of the Toast platform restaurant location.  * `false` - The marketplace facilitator has not paid the tax amount. The Toast platform restaurant location may be required to pay the tax amount.  **Note**: Toast API response data is not guidance or advice for tax compliance. ", alias="facilitatorCollectAndRemitTax")
    display_name: Optional[StrictStr] = Field(default=None, description="The name of the tax rate as it appears on guest receipts.", alias="displayName")
    jurisdiction: Optional[StrictStr] = Field(default=None, description="The state or province of the tax rate for reporting purposes.")
    jurisdiction_type: Optional[StrictStr] = Field(default=None, description="The jurisdiction type (ex. STATE, COUNTY, etc.) of the tax rate for reporting purposes.", alias="jurisdictionType")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "taxRate", "name", "rate", "taxAmount", "type", "facilitatorCollectAndRemitTax", "displayName", "jurisdiction", "jurisdictionType"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PERCENT', 'FIXED', 'NONE', 'TABLE', 'EXTERNAL']):
            raise ValueError("must be one of enum values ('PERCENT', 'FIXED', 'NONE', 'TABLE', 'EXTERNAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppliedTaxRate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_rate
        if self.tax_rate:
            _dict['taxRate'] = self.tax_rate.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppliedTaxRate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "taxRate": ToastReference.from_dict(obj["taxRate"]) if obj.get("taxRate") is not None else None,
            "name": obj.get("name"),
            "rate": obj.get("rate"),
            "taxAmount": obj.get("taxAmount"),
            "type": obj.get("type"),
            "facilitatorCollectAndRemitTax": obj.get("facilitatorCollectAndRemitTax"),
            "displayName": obj.get("displayName"),
            "jurisdiction": obj.get("jurisdiction"),
            "jurisdictionType": obj.get("jurisdictionType")
        })
        return _obj


