# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.device import Device
from toastapi.models.external_reference import ExternalReference
from toastapi.models.refund import Refund
from toastapi.models.void_information import VoidInformation
from typing import Optional, Set
from typing_extensions import Self

class Payment(BaseModel):
    """
    Defines a payment.
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    paid_date: Optional[datetime] = Field(default=None, description="The date on which the payment was made.", alias="paidDate")
    paid_business_date: Optional[StrictInt] = Field(default=None, description="The business date (yyyyMMdd) on which this payment was first applied. Response only.", alias="paidBusinessDate")
    type: StrictStr = Field(description="The payment method.  When `POST`ing, only `OTHER` and `CREDIT` payment types are supported. For cash payments, you create an external cash payment type in Other Payment Options.  All other types are response only.  Valid values:  * `CASH` - The guest paid in cash. * `CREDIT` - The guest used a credit card. * `GIFTCARD` - The guest used a gift card. * `HOUSE_ACCOUNT` - The guest used funds from their house account. * `REWARDCARD` - The guest used the available balance on a rewards card. * `LEVELUP` - The guest used the LevelUp app. * `TOAST_SV` - The guest used their Toast Cash stored value. * `OTHER` - The payment type is a custom type configured by the restaurant. * `UNDETERMINED` - The payment type cannot be determined. ")
    card_entry_mode: Optional[StrictStr] = Field(default=None, description="Indicates how credit card data was obtained. Response only.  Valid values:  * `SWIPED` - The credit card was swiped through a card reader. * `KEYED` - The restaurant employee typed the card number into a device. * `ONLINE` - The credit card information was entered online. * `EMV_CHIP_SIGN` - The credit card was inserted into a chip reader. * `TOKENIZED` - The credit card number is tokenized, meaning that it is replaced by a series of randomly generated numbers. The authorizer is able to use the token to authorize the actual credit card. * `PRE_AUTHED` - The credit card was pre-authorized for an initial amount. An example of pre-authorization is swiping a credit card to start a bar tab. The final payment is authorized when the order is complete. * `SAVED_CARD` - The credit card information was retrieved from the guest's account. * `FUTURE_ORDER` - The credit card payment was included on a scheduled order. * `CONTACTLESS` - The guest used a contactless payment option to provide the credit card number. * `APPLE_PAY_CNP` - The guest used the Apple Pay app to make the payment. * `GOOGLE_PAY_CNP` - The guest used the Google Pay app to make the payment. * `INCREMENTAL_PRE_AUTHED` - An additional payment was added to a pre-authorized card. For example, a guest uses a credit card to open a bar tab. As they continue to order more drinks, the pre-authorized amount is updated. The final payment is authorized when the order is complete. * `PARTNER_ECOM_COF` - The restaurant has the credit card on file. * `CLICK_TO_PAY_CNP` - The guest used Click to Pay to make the payment. ", alias="cardEntryMode")
    amount: Union[StrictFloat, StrictInt] = Field(description="The amount of this payment, excluding tips.")
    tip_amount: Union[StrictFloat, StrictInt] = Field(description="The amount tipped on this payment.", alias="tipAmount")
    amount_tendered: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount tendered for this payment. The amount tendered does not include the tip.", alias="amountTendered")
    card_type: Optional[StrictStr] = Field(default=None, description="The type of credit card that was used. Response only.", alias="cardType")
    last4_digits: Optional[StrictStr] = Field(default=None, description="The last 4 digits of the credit card that was used. Response only.", alias="last4Digits")
    server: Optional[ExternalReference] = None
    refund_status: Optional[StrictStr] = Field(default=None, description="Indicates whether the payment was refunded. Response only. ", alias="refundStatus")
    payment_status: Optional[StrictStr] = Field(default=None, description="The status of this payment when the type is `CREDIT`. Response only. ", alias="paymentStatus")
    original_processing_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The original processing fee for this payment. Populated after the payment is captured. Response only.", alias="originalProcessingFee")
    cash_drawer: Optional[ExternalReference] = Field(default=None, alias="cashDrawer")
    refund: Optional[Refund] = None
    void_info: Optional[VoidInformation] = Field(default=None, alias="voidInfo")
    house_account: Optional[ExternalReference] = Field(default=None, alias="houseAccount")
    other_payment: Optional[ExternalReference] = Field(default=None, alias="otherPayment")
    created_device: Optional[Device] = Field(default=None, alias="createdDevice")
    last_modified_device: Optional[Device] = Field(default=None, alias="lastModifiedDevice")
    mca_repayment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total currency amount withheld as payments or repayments that apply to your business. For example, the `mcaRepaymentAmount` might include:  * Toast Capital payments * Marketplace facilitator tax * Toast Delivery Services costs * Instant deposits  The MCA repayment amount is set at the time the payment is captured, which is typically hours after the actual restaurant guest payment.  Until the `mcaRepaymentAmount` is set, this value is `null`.  The `mcaRepaymentAmount` _might_ be updated when the payment is settled, which is typically one or more days after the actual guest payment. Response only.  You can use the following resources to find more specific information about the payment and repayment amounts that are included in `mcaRepaymentAmount`.  * [Toast Capital payments](https://www.toasttab.com/restaurants/admin/capital/) * [Marketplace facilitator tax](https://www.toasttab.com/restaurants/admin/reports/home#sales-summary) * [Marketplace facilitator tax in API data](https://doc.toasttab.com/openapi/orders/tag/Data-definitions/schema/MarketplaceFacilitatorTaxInfo/) * [Instant deposits](https://www.toasttab.com/restaurants/admin/instant-deposit) * [Toast Delivery Services fees and tips](https://www.toasttab.com/restaurants/admin/reports/home#sales-summary) * [Toast Delivery Services fees and tips description](https://www.toasttab.com/restaurants/admin/reports/home#sales-summary)  _Important_: Some of the resources listed here require access to Toast products as a restaurant employee or operator. If your organization provides an integration service you might not have access to the Toast products used by the restaurants you integrate with. Toast support cannot provide access to Toast product information. That information is only available to direct Toast product users. ", alias="mcaRepaymentAmount")
    card_payment_id: Optional[StrictStr] = Field(default=None, description="**Note:** this value is in limited release. Your orders API integration might not include the `cardPaymentId` value.  A unique identifier for the credit card used for a `CREDIT` type payment. The identifier string is generated by the Toast platform and _does not include any information related to or associated with the actual credit card account._ The identifier is unique within your restaurant management group.  The value is `null` for the following payment types:  * Payment types other than `CREDIT` * Credit card payments entered using EMV (chip cards) * Credit card payments entered by keying in card numbers  Response only. ", alias="cardPaymentId")
    order_guid: Optional[StrictStr] = Field(default=None, description="The Toast platform identifier for the order that contains the payment. Response only.", alias="orderGuid")
    check_guid: Optional[StrictStr] = Field(default=None, description="The Toast platform identifier for the check that contains the payment. Response only.", alias="checkGuid")
    tender_transaction_guid: Optional[StrictStr] = Field(default=None, description="For internal use only.", alias="tenderTransactionGuid")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "paidDate", "paidBusinessDate", "type", "cardEntryMode", "amount", "tipAmount", "amountTendered", "cardType", "last4Digits", "server", "refundStatus", "paymentStatus", "originalProcessingFee", "cashDrawer", "refund", "voidInfo", "houseAccount", "otherPayment", "createdDevice", "lastModifiedDevice", "mcaRepaymentAmount", "cardPaymentId", "orderGuid", "checkGuid", "tenderTransactionGuid"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CASH', 'CREDIT', 'GIFTCARD', 'HOUSE_ACCOUNT', 'REWARDCARD', 'LEVELUP', 'TOAST_SV', 'OTHER', 'UNDETERMINED']):
            raise ValueError("must be one of enum values ('CASH', 'CREDIT', 'GIFTCARD', 'HOUSE_ACCOUNT', 'REWARDCARD', 'LEVELUP', 'TOAST_SV', 'OTHER', 'UNDETERMINED')")
        return value

    @field_validator('card_entry_mode')
    def card_entry_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SWIPED', 'KEYED', 'ONLINE', 'EMV_CHIP_SIGN', 'TOKENIZED', 'PRE_AUTHED', 'SAVED_CARD', 'FUTURE_ORDER', 'CONTACTLESS', 'APPLE_PAY_CNP', 'GOOGLE_PAY_CNP', 'INCREMENTAL_PRE_AUTHED', 'PARTNER_ECOM_COF', 'CLICK_TO_PAY_CNP']):
            raise ValueError("must be one of enum values ('SWIPED', 'KEYED', 'ONLINE', 'EMV_CHIP_SIGN', 'TOKENIZED', 'PRE_AUTHED', 'SAVED_CARD', 'FUTURE_ORDER', 'CONTACTLESS', 'APPLE_PAY_CNP', 'GOOGLE_PAY_CNP', 'INCREMENTAL_PRE_AUTHED', 'PARTNER_ECOM_COF', 'CLICK_TO_PAY_CNP')")
        return value

    @field_validator('card_type')
    def card_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['VISA', 'MASTERCARD', 'AMEX', 'DISCOVER', 'JCB', 'DINERS', 'CIT', 'MAESTRO', 'LASER', 'SOLO', 'INTERAC', 'EFTPOS', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('VISA', 'MASTERCARD', 'AMEX', 'DISCOVER', 'JCB', 'DINERS', 'CIT', 'MAESTRO', 'LASER', 'SOLO', 'INTERAC', 'EFTPOS', 'UNKNOWN')")
        return value

    @field_validator('refund_status')
    def refund_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NONE', 'PARTIAL', 'FULL']):
            raise ValueError("must be one of enum values ('NONE', 'PARTIAL', 'FULL')")
        return value

    @field_validator('payment_status')
    def payment_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OPEN', 'PROCESSING', 'AUTHORIZED_AT_RISK', 'AUTHORIZED', 'ERROR', 'ERROR_NETWORK', 'DENIED', 'PROCESSING_VOID', 'VOIDED_AT_RISK', 'CANCELLED', 'CAPTURE_IN_PROGRESS', 'CAPTURED', 'VOIDED']):
            raise ValueError("must be one of enum values ('OPEN', 'PROCESSING', 'AUTHORIZED_AT_RISK', 'AUTHORIZED', 'ERROR', 'ERROR_NETWORK', 'DENIED', 'PROCESSING_VOID', 'VOIDED_AT_RISK', 'CANCELLED', 'CAPTURE_IN_PROGRESS', 'CAPTURED', 'VOIDED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Payment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cash_drawer
        if self.cash_drawer:
            _dict['cashDrawer'] = self.cash_drawer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund
        if self.refund:
            _dict['refund'] = self.refund.to_dict()
        # override the default output from pydantic by calling `to_dict()` of void_info
        if self.void_info:
            _dict['voidInfo'] = self.void_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of house_account
        if self.house_account:
            _dict['houseAccount'] = self.house_account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of other_payment
        if self.other_payment:
            _dict['otherPayment'] = self.other_payment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_device
        if self.created_device:
            _dict['createdDevice'] = self.created_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_device
        if self.last_modified_device:
            _dict['lastModifiedDevice'] = self.last_modified_device.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Payment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "paidDate": obj.get("paidDate"),
            "paidBusinessDate": obj.get("paidBusinessDate"),
            "type": obj.get("type"),
            "cardEntryMode": obj.get("cardEntryMode"),
            "amount": obj.get("amount"),
            "tipAmount": obj.get("tipAmount"),
            "amountTendered": obj.get("amountTendered"),
            "cardType": obj.get("cardType"),
            "last4Digits": obj.get("last4Digits"),
            "server": ExternalReference.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "refundStatus": obj.get("refundStatus"),
            "paymentStatus": obj.get("paymentStatus"),
            "originalProcessingFee": obj.get("originalProcessingFee"),
            "cashDrawer": ExternalReference.from_dict(obj["cashDrawer"]) if obj.get("cashDrawer") is not None else None,
            "refund": Refund.from_dict(obj["refund"]) if obj.get("refund") is not None else None,
            "voidInfo": VoidInformation.from_dict(obj["voidInfo"]) if obj.get("voidInfo") is not None else None,
            "houseAccount": ExternalReference.from_dict(obj["houseAccount"]) if obj.get("houseAccount") is not None else None,
            "otherPayment": ExternalReference.from_dict(obj["otherPayment"]) if obj.get("otherPayment") is not None else None,
            "createdDevice": Device.from_dict(obj["createdDevice"]) if obj.get("createdDevice") is not None else None,
            "lastModifiedDevice": Device.from_dict(obj["lastModifiedDevice"]) if obj.get("lastModifiedDevice") is not None else None,
            "mcaRepaymentAmount": obj.get("mcaRepaymentAmount"),
            "cardPaymentId": obj.get("cardPaymentId"),
            "orderGuid": obj.get("orderGuid"),
            "checkGuid": obj.get("checkGuid"),
            "tenderTransactionGuid": obj.get("tenderTransactionGuid")
        })
        return _obj


