# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from toastapi.models.size_sequence_pricing_rule import SizeSequencePricingRule
from toastapi.models.time_specific_price import TimeSpecificPrice
from typing import Optional, Set
from typing_extensions import Self

class PricingRules(BaseModel):
    """
    The PricingRules object is a multi-use object that provides pricing rules for:   * A menu item or modifier option item reference that uses the Time Specific Price or Size Price pricing strategy.   * A modifier group that uses the Size Price, Sequence Price, or Size/Sequence Price pricing strategy. 
    """ # noqa: E501
    time_specific_pricing_rules: Optional[List[TimeSpecificPrice]] = Field(default=None, description="An array of `TimeSpecificPrice` objects that define the time-specific prices for a menu item or modifier option item reference that uses the Time Specific Price pricing strategy. If the menu item or modifier option item reference does not use time-specific prices, this array is empty. ", alias="timeSpecificPricingRules")
    size_specific_pricing_guid: Optional[StrictStr] = Field(default=None, description="The GUID of a Size modifier group that defines sizes and prices for a menu item or a modifier option item reference that uses the Size Price pricing strategy. If the menu item or modifier option item reference does not use the Size Price pricing strategy, then `sizeSpecificPricingGuid` is null. ", alias="sizeSpecificPricingGuid")
    size_sequence_pricing_rules: Optional[List[SizeSequencePricingRule]] = Field(default=None, description="An array of `SizeSequencePricingRule` objects that define the prices for the modifier options in a modifier group that uses the Size Price, Sequence Price, or Size/Sequence Pricing pricing strategy. If the modifier group does not use one of these pricing strategies, this array is empty. ", alias="sizeSequencePricingRules")
    __properties: ClassVar[List[str]] = ["timeSpecificPricingRules", "sizeSpecificPricingGuid", "sizeSequencePricingRules"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PricingRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in time_specific_pricing_rules (list)
        _items = []
        if self.time_specific_pricing_rules:
            for _item_time_specific_pricing_rules in self.time_specific_pricing_rules:
                if _item_time_specific_pricing_rules:
                    _items.append(_item_time_specific_pricing_rules.to_dict())
            _dict['timeSpecificPricingRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in size_sequence_pricing_rules (list)
        _items = []
        if self.size_sequence_pricing_rules:
            for _item_size_sequence_pricing_rules in self.size_sequence_pricing_rules:
                if _item_size_sequence_pricing_rules:
                    _items.append(_item_size_sequence_pricing_rules.to_dict())
            _dict['sizeSequencePricingRules'] = _items
        # set to None if size_specific_pricing_guid (nullable) is None
        # and model_fields_set contains the field
        if self.size_specific_pricing_guid is None and "size_specific_pricing_guid" in self.model_fields_set:
            _dict['sizeSpecificPricingGuid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PricingRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timeSpecificPricingRules": [TimeSpecificPrice.from_dict(_item) for _item in obj["timeSpecificPricingRules"]] if obj.get("timeSpecificPricingRules") is not None else None,
            "sizeSpecificPricingGuid": obj.get("sizeSpecificPricingGuid"),
            "sizeSequencePricingRules": [SizeSequencePricingRule.from_dict(_item) for _item in obj["sizeSequencePricingRules"]] if obj.get("sizeSequencePricingRules") is not None else None
        })
        return _obj


