# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from toastapi.models.menu import Menu
from toastapi.models.modifier_group import ModifierGroup
from toastapi.models.modifier_option import ModifierOption
from toastapi.models.pre_modifier_group import PreModifierGroup
from typing import Optional, Set
from typing_extensions import Self

class Restaurant(BaseModel):
    """
    Information about the restaurant whose menu data has been retrieved. 
    """ # noqa: E501
    restaurant_guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this restaurant, assigned by the Toast POS system. ", alias="restaurantGuid")
    last_updated: Optional[StrictStr] = Field(default=None, description="The most recent date and time that this menu's data was published. Use this value to determine if you need to refresh your menu data. The `lastUpdated` value uses the absolute timestamp format describe in the <a href=\"https://doc.toasttab.com/doc/devguide/api_dates_and_timestamps.html\">Dates and timestamps</a> section of the Toast Developer Guide. ", alias="lastUpdated")
    restaurant_time_zone: Optional[StrictStr] = Field(default=None, description="The name of the restaurant's time zone in the IANA time zone database https://www.iana.org/time-zones. For example, \"America/New_York\". ", alias="restaurantTimeZone")
    menus: Optional[List[Menu]] = Field(default=None, description="An array of `Menu` objects that represent the published menus used by this restaurant. ")
    modifier_group_references: Optional[Dict[str, ModifierGroup]] = Field(default=None, description="A map of `ModifierGroup` objects that define the modifier groups used by this restaurant. Each `ModifierGroup` object is presented as a key/value pair. A pair's key matches the `referenceId` of the object contained in the pair's value, as shown below: ``` \"modifierGroupReferences\": {   \"3\": {     \"referenceId\": 3,     \"name\": \"Toppings\",     \"guid\": \"58b79986-f88f-411d-ba18-14b1e2441e9d\",     \"modifierOptionReferences\": [10, 11],     ...   },   \"4\": {     \"referenceId\": 4,     \"name\": \"Size\",     \"guid\": \"23c02762-9d6a-4d3f-a298-71c989bf31b0\",     \"modifierOptionReferences\": [12, 13],     ...   } } ```  Other menu entities refer to modifier groups using their `referenceId`. Having a key that matches the `referenceId` allows you to locate the correct modifier group in the `modifierGroupReferences` map. ", alias="modifierGroupReferences")
    modifier_option_references: Optional[Dict[str, ModifierOption]] = Field(default=None, description="A map of `ModifierOption` objects that define the modifier options used by this restaurant. Each `ModifierOption` object is presented as a key/value pair. A pair's key matches the `referenceId` of the object contained in the pair's value, as shown below: ``` \"modifierOptionReferences\": {   \"10\": {     \"referenceId\": 10,     \"name\": \"Mushrooms\",     \"guid\": \"fa24fee9-76c4-40ba-ae3c-7dfccafdd8d3\",     \"price\": 1.50,     ...   },   \"11\": {     \"referenceId\": 11,     \"name\": \"Onions\",     \"guid\": \"afee6be7-8280-4c69-a170-9fdf4c76bf7b\",     \"price\": 0.75,     ...   } } ``` ", alias="modifierOptionReferences")
    pre_modifier_group_references: Optional[Dict[str, PreModifierGroup]] = Field(default=None, description="A map of `PreModifierGroup` objects that define the premodifier groups used by this restaurant. Each `PreModifierGroup` object is presented as a key/value pair. A pair's key matches the `referenceId` of the object contained in the pair's value, as shown below: ``` \"preModifierGroupReferences\": {   \"22\": {     \"referenceId\": 22,     \"guid\": \"07a1a94d-6f7b-46d5-a916-a07fa16bb8e8\",     \"name\": \"PreModGroup\",     \"preModifiers\": [       {         \"guid\": \"ad45e697-9356-468e-b7b4-1b23f4d4b8a5\",         \"name\": \"EXTRA\",         \"fixedPrice\": 1.0,         \"multiplicationFactor\": null       }     ]   } } ``` ", alias="preModifierGroupReferences")
    __properties: ClassVar[List[str]] = ["restaurantGuid", "lastUpdated", "restaurantTimeZone", "menus", "modifierGroupReferences", "modifierOptionReferences", "preModifierGroupReferences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Restaurant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in menus (list)
        _items = []
        if self.menus:
            for _item_menus in self.menus:
                if _item_menus:
                    _items.append(_item_menus.to_dict())
            _dict['menus'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in modifier_group_references (dict)
        _field_dict = {}
        if self.modifier_group_references:
            for _key_modifier_group_references in self.modifier_group_references:
                if self.modifier_group_references[_key_modifier_group_references]:
                    _field_dict[_key_modifier_group_references] = self.modifier_group_references[_key_modifier_group_references].to_dict()
            _dict['modifierGroupReferences'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in modifier_option_references (dict)
        _field_dict = {}
        if self.modifier_option_references:
            for _key_modifier_option_references in self.modifier_option_references:
                if self.modifier_option_references[_key_modifier_option_references]:
                    _field_dict[_key_modifier_option_references] = self.modifier_option_references[_key_modifier_option_references].to_dict()
            _dict['modifierOptionReferences'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in pre_modifier_group_references (dict)
        _field_dict = {}
        if self.pre_modifier_group_references:
            for _key_pre_modifier_group_references in self.pre_modifier_group_references:
                if self.pre_modifier_group_references[_key_pre_modifier_group_references]:
                    _field_dict[_key_pre_modifier_group_references] = self.pre_modifier_group_references[_key_pre_modifier_group_references].to_dict()
            _dict['preModifierGroupReferences'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Restaurant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "restaurantGuid": obj.get("restaurantGuid"),
            "lastUpdated": obj.get("lastUpdated"),
            "restaurantTimeZone": obj.get("restaurantTimeZone"),
            "menus": [Menu.from_dict(_item) for _item in obj["menus"]] if obj.get("menus") is not None else None,
            "modifierGroupReferences": dict(
                (_k, ModifierGroup.from_dict(_v))
                for _k, _v in obj["modifierGroupReferences"].items()
            )
            if obj.get("modifierGroupReferences") is not None
            else None,
            "modifierOptionReferences": dict(
                (_k, ModifierOption.from_dict(_v))
                for _k, _v in obj["modifierOptionReferences"].items()
            )
            if obj.get("modifierOptionReferences") is not None
            else None,
            "preModifierGroupReferences": dict(
                (_k, PreModifierGroup.from_dict(_v))
                for _k, _v in obj["preModifierGroupReferences"].items()
            )
            if obj.get("preModifierGroupReferences") is not None
            else None
        })
        return _obj


