# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ServiceChargeCriteria(BaseModel):
    """
    Describes thresholds for when a service charge should be applied to a check.
    """ # noqa: E501
    min_check_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The service charge is only applicable if the pre-discount check is at least this amount.", alias="minCheckAmount")
    delivery: Optional[StrictBool] = Field(default=None, description="True if the service charge is only applicable for deliveries.")
    max_check_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The service charge is waived if the pre-discount check amount is more than this amount. A `null` value means this criteria is inapplicable.", alias="maxCheckAmount")
    min_delivery_distance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The service charge is only applicable to deliveries that are at least this distance. A `null` value means this criteria is inapplicable.", alias="minDeliveryDistance")
    takeout: Optional[StrictBool] = Field(default=None, description="Indicates whether the service charge is automatically applied to orders that have the takeout dining option behavior.")
    dine_in: Optional[StrictBool] = Field(default=None, description="Indicates whether the service charge is applied to orders that have the dine-in dining option behavior.", alias="dineIn")
    __properties: ClassVar[List[str]] = ["minCheckAmount", "delivery", "maxCheckAmount", "minDeliveryDistance", "takeout", "dineIn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceChargeCriteria from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceChargeCriteria from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "minCheckAmount": obj.get("minCheckAmount"),
            "delivery": obj.get("delivery"),
            "maxCheckAmount": obj.get("maxCheckAmount"),
            "minDeliveryDistance": obj.get("minDeliveryDistance"),
            "takeout": obj.get("takeout"),
            "dineIn": obj.get("dineIn")
        })
        return _obj


