# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoScalingConfigurationArgs', 'AutoScalingConfiguration']

@pulumi.input_type
class AutoScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_scaling_resources: pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs'],
                 compartment_id: pulumi.Input[str],
                 policies: pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]],
                 cool_down_in_seconds: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AutoScalingConfiguration resource.
        :param pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs'] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.
               
               Each instance pool can have one autoscaling configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param pulumi.Input[int] cool_down_in_seconds: (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
               
               For schedule-based autoscaling policies, this value is not used.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: Whether the autoscaling policy is enabled.
        """
        pulumi.set(__self__, "auto_scaling_resources", auto_scaling_resources)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "policies", policies)
        if cool_down_in_seconds is not None:
            pulumi.set(__self__, "cool_down_in_seconds", cool_down_in_seconds)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.

        Each instance pool can have one autoscaling configuration.
        """
        return pulumi.get(self, "auto_scaling_resources")

    @auto_scaling_resources.setter
    def auto_scaling_resources(self, value: pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs']):
        pulumi.set(self, "auto_scaling_resources", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]]:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.

        For schedule-based autoscaling policies, this value is not used.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @cool_down_in_seconds.setter
    def cool_down_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_in_seconds", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class _AutoScalingConfigurationState:
    def __init__(__self__, *,
                 auto_scaling_resources: Optional[pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cool_down_in_seconds: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 max_resource_count: Optional[pulumi.Input[int]] = None,
                 min_resource_count: Optional[pulumi.Input[int]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutoScalingConfiguration resources.
        :param pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs'] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.
               
               Each instance pool can have one autoscaling configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        :param pulumi.Input[int] cool_down_in_seconds: (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
               
               For schedule-based autoscaling policies, this value is not used.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: Whether the autoscaling policy is enabled.
        :param pulumi.Input[int] max_resource_count: The maximum number of resources to scale out to.
        :param pulumi.Input[int] min_resource_count: The minimum number of resources to scale in to.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param pulumi.Input[str] time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        if auto_scaling_resources is not None:
            pulumi.set(__self__, "auto_scaling_resources", auto_scaling_resources)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cool_down_in_seconds is not None:
            pulumi.set(__self__, "cool_down_in_seconds", cool_down_in_seconds)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_resource_count is not None:
            pulumi.set(__self__, "max_resource_count", max_resource_count)
        if min_resource_count is not None:
            pulumi.set(__self__, "min_resource_count", min_resource_count)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> Optional[pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs']]:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.

        Each instance pool can have one autoscaling configuration.
        """
        return pulumi.get(self, "auto_scaling_resources")

    @auto_scaling_resources.setter
    def auto_scaling_resources(self, value: Optional[pulumi.Input['AutoScalingConfigurationAutoScalingResourcesArgs']]):
        pulumi.set(self, "auto_scaling_resources", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.

        For schedule-based autoscaling policies, this value is not used.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @cool_down_in_seconds.setter
    def cool_down_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_in_seconds", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @max_resource_count.setter
    def max_resource_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_resource_count", value)

    @property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @min_resource_count.setter
    def min_resource_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_resource_count", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]]]:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingConfigurationPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class AutoScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_resources: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationAutoScalingResourcesArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cool_down_in_seconds: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Auto Scaling Configuration resource in Oracle Cloud Infrastructure Auto Scaling service.

        Creates an autoscaling configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_auto_scaling_configuration = oci.autoscaling.AutoScalingConfiguration("testAutoScalingConfiguration",
            auto_scaling_resources=oci.autoscaling.AutoScalingConfigurationAutoScalingResourcesArgs(
                id=var["auto_scaling_configuration_auto_scaling_resources_id"],
                type=var["auto_scaling_configuration_auto_scaling_resources_type"],
            ),
            compartment_id=var["compartment_id"],
            policies=[oci.autoscaling.AutoScalingConfigurationPolicyArgs(
                policy_type=var["auto_scaling_configuration_policies_policy_type"],
                capacity=oci.autoscaling.AutoScalingConfigurationPolicyCapacityArgs(
                    initial=var["auto_scaling_configuration_policies_capacity_initial"],
                    max=var["auto_scaling_configuration_policies_capacity_max"],
                    min=var["auto_scaling_configuration_policies_capacity_min"],
                ),
                display_name=var["auto_scaling_configuration_policies_display_name"],
                execution_schedule=oci.autoscaling.AutoScalingConfigurationPolicyExecutionScheduleArgs(
                    expression=var["auto_scaling_configuration_policies_execution_schedule_expression"],
                    timezone=var["auto_scaling_configuration_policies_execution_schedule_timezone"],
                    type=var["auto_scaling_configuration_policies_execution_schedule_type"],
                ),
                is_enabled=var["auto_scaling_configuration_policies_is_enabled"],
                resource_action=oci.autoscaling.AutoScalingConfigurationPolicyResourceActionArgs(
                    action=var["auto_scaling_configuration_policies_resource_action_action"],
                    action_type=var["auto_scaling_configuration_policies_resource_action_action_type"],
                ),
                rules=[oci.autoscaling.AutoScalingConfigurationPolicyRuleArgs(
                    action=oci.autoscaling.AutoScalingConfigurationPolicyRuleActionArgs(
                        type=var["auto_scaling_configuration_policies_rules_action_type"],
                        value=var["auto_scaling_configuration_policies_rules_action_value"],
                    ),
                    display_name=var["auto_scaling_configuration_policies_rules_display_name"],
                    metric=oci.autoscaling.AutoScalingConfigurationPolicyRuleMetricArgs(
                        metric_type=var["auto_scaling_configuration_policies_rules_metric_metric_type"],
                        threshold=oci.autoscaling.AutoScalingConfigurationPolicyRuleMetricThresholdArgs(
                            operator=var["auto_scaling_configuration_policies_rules_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policies_rules_metric_threshold_value"],
                        ),
                    ),
                )],
            )],
            cool_down_in_seconds=var["auto_scaling_configuration_cool_down_in_seconds"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["auto_scaling_configuration_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_enabled=var["auto_scaling_configuration_is_enabled"])
        ```

        ## Import

        AutoScalingConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Autoscaling/autoScalingConfiguration:AutoScalingConfiguration test_auto_scaling_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationAutoScalingResourcesArgs']] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.
               
               Each instance pool can have one autoscaling configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        :param pulumi.Input[int] cool_down_in_seconds: (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
               
               For schedule-based autoscaling policies, this value is not used.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: Whether the autoscaling policy is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]]] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Auto Scaling Configuration resource in Oracle Cloud Infrastructure Auto Scaling service.

        Creates an autoscaling configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_auto_scaling_configuration = oci.autoscaling.AutoScalingConfiguration("testAutoScalingConfiguration",
            auto_scaling_resources=oci.autoscaling.AutoScalingConfigurationAutoScalingResourcesArgs(
                id=var["auto_scaling_configuration_auto_scaling_resources_id"],
                type=var["auto_scaling_configuration_auto_scaling_resources_type"],
            ),
            compartment_id=var["compartment_id"],
            policies=[oci.autoscaling.AutoScalingConfigurationPolicyArgs(
                policy_type=var["auto_scaling_configuration_policies_policy_type"],
                capacity=oci.autoscaling.AutoScalingConfigurationPolicyCapacityArgs(
                    initial=var["auto_scaling_configuration_policies_capacity_initial"],
                    max=var["auto_scaling_configuration_policies_capacity_max"],
                    min=var["auto_scaling_configuration_policies_capacity_min"],
                ),
                display_name=var["auto_scaling_configuration_policies_display_name"],
                execution_schedule=oci.autoscaling.AutoScalingConfigurationPolicyExecutionScheduleArgs(
                    expression=var["auto_scaling_configuration_policies_execution_schedule_expression"],
                    timezone=var["auto_scaling_configuration_policies_execution_schedule_timezone"],
                    type=var["auto_scaling_configuration_policies_execution_schedule_type"],
                ),
                is_enabled=var["auto_scaling_configuration_policies_is_enabled"],
                resource_action=oci.autoscaling.AutoScalingConfigurationPolicyResourceActionArgs(
                    action=var["auto_scaling_configuration_policies_resource_action_action"],
                    action_type=var["auto_scaling_configuration_policies_resource_action_action_type"],
                ),
                rules=[oci.autoscaling.AutoScalingConfigurationPolicyRuleArgs(
                    action=oci.autoscaling.AutoScalingConfigurationPolicyRuleActionArgs(
                        type=var["auto_scaling_configuration_policies_rules_action_type"],
                        value=var["auto_scaling_configuration_policies_rules_action_value"],
                    ),
                    display_name=var["auto_scaling_configuration_policies_rules_display_name"],
                    metric=oci.autoscaling.AutoScalingConfigurationPolicyRuleMetricArgs(
                        metric_type=var["auto_scaling_configuration_policies_rules_metric_metric_type"],
                        threshold=oci.autoscaling.AutoScalingConfigurationPolicyRuleMetricThresholdArgs(
                            operator=var["auto_scaling_configuration_policies_rules_metric_threshold_operator"],
                            value=var["auto_scaling_configuration_policies_rules_metric_threshold_value"],
                        ),
                    ),
                )],
            )],
            cool_down_in_seconds=var["auto_scaling_configuration_cool_down_in_seconds"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["auto_scaling_configuration_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_enabled=var["auto_scaling_configuration_is_enabled"])
        ```

        ## Import

        AutoScalingConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Autoscaling/autoScalingConfiguration:AutoScalingConfiguration test_auto_scaling_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutoScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_resources: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationAutoScalingResourcesArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cool_down_in_seconds: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoScalingConfigurationArgs.__new__(AutoScalingConfigurationArgs)

            if auto_scaling_resources is None and not opts.urn:
                raise TypeError("Missing required property 'auto_scaling_resources'")
            __props__.__dict__["auto_scaling_resources"] = auto_scaling_resources
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["cool_down_in_seconds"] = cool_down_in_seconds
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["max_resource_count"] = None
            __props__.__dict__["min_resource_count"] = None
            __props__.__dict__["time_created"] = None
        super(AutoScalingConfiguration, __self__).__init__(
            'oci:Autoscaling/autoScalingConfiguration:AutoScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scaling_resources: Optional[pulumi.Input[pulumi.InputType['AutoScalingConfigurationAutoScalingResourcesArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cool_down_in_seconds: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            max_resource_count: Optional[pulumi.Input[int]] = None,
            min_resource_count: Optional[pulumi.Input[int]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'AutoScalingConfiguration':
        """
        Get an existing AutoScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AutoScalingConfigurationAutoScalingResourcesArgs']] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.
               
               Each instance pool can have one autoscaling configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        :param pulumi.Input[int] cool_down_in_seconds: (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
               
               For schedule-based autoscaling policies, this value is not used.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_enabled: Whether the autoscaling policy is enabled.
        :param pulumi.Input[int] max_resource_count: The maximum number of resources to scale out to.
        :param pulumi.Input[int] min_resource_count: The minimum number of resources to scale in to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutoScalingConfigurationPolicyArgs']]]] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param pulumi.Input[str] time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoScalingConfigurationState.__new__(_AutoScalingConfigurationState)

        __props__.__dict__["auto_scaling_resources"] = auto_scaling_resources
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cool_down_in_seconds"] = cool_down_in_seconds
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["max_resource_count"] = max_resource_count
        __props__.__dict__["min_resource_count"] = min_resource_count
        __props__.__dict__["policies"] = policies
        __props__.__dict__["time_created"] = time_created
        return AutoScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> pulumi.Output['outputs.AutoScalingConfigurationAutoScalingResources']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is `instancePool`.

        Each instance pool can have one autoscaling configuration.
        """
        return pulumi.get(self, "auto_scaling_resources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the autoscaling configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.

        For schedule-based autoscaling policies, this value is not used.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> pulumi.Output[int]:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> pulumi.Output[int]:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.AutoScalingConfigurationPolicy']]:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

