# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CaptureFilterArgs', 'CaptureFilter']

@pulumi.input_type
class CaptureFilterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 filter_type: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]] = None):
        """
        The set of arguments for constructing a CaptureFilter resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "filter_type", filter_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if vtap_capture_filter_rules is not None:
            pulumi.set(__self__, "vtap_capture_filter_rules", vtap_capture_filter_rules)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[str]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

    @vtap_capture_filter_rules.setter
    def vtap_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "vtap_capture_filter_rules", value)


@pulumi.input_type
class _CaptureFilterState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering CaptureFilter resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] state: The capture filter's current administrative state.
        :param pulumi.Input[str] time_created: The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vtap_capture_filter_rules is not None:
            pulumi.set(__self__, "vtap_capture_filter_rules", vtap_capture_filter_rules)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The capture filter's current administrative state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

    @vtap_capture_filter_rules.setter
    def vtap_capture_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CaptureFilterVtapCaptureFilterRuleArgs']]]]):
        pulumi.set(self, "vtap_capture_filter_rules", value)


class CaptureFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CaptureFilterVtapCaptureFilterRuleArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Capture Filter resource in Oracle Cloud Infrastructure Core service.

        Creates a virtual test access point (VTAP) capture filter in the specified compartment.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains
        the VTAP. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VTAP, otherwise a default is provided.
        It does not have to be unique, and you can change it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_capture_filter = oci.core.CaptureFilter("testCaptureFilter",
            compartment_id=var["compartment_id"],
            filter_type=var["capture_filter_filter_type"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["capture_filter_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            vtap_capture_filter_rules=[oci.core.CaptureFilterVtapCaptureFilterRuleArgs(
                traffic_direction=var["capture_filter_vtap_capture_filter_rules_traffic_direction"],
                destination_cidr=var["capture_filter_vtap_capture_filter_rules_destination_cidr"],
                icmp_options=oci.core.CaptureFilterVtapCaptureFilterRuleIcmpOptionsArgs(
                    type=var["capture_filter_vtap_capture_filter_rules_icmp_options_type"],
                    code=var["capture_filter_vtap_capture_filter_rules_icmp_options_code"],
                ),
                protocol=var["capture_filter_vtap_capture_filter_rules_protocol"],
                rule_action=var["capture_filter_vtap_capture_filter_rules_rule_action"],
                source_cidr=var["capture_filter_vtap_capture_filter_rules_source_cidr"],
                tcp_options=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsArgs(
                    destination_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsDestinationPortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_min"],
                    ),
                    source_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsSourcePortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_min"],
                    ),
                ),
                udp_options=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsArgs(
                    destination_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsDestinationPortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_min"],
                    ),
                    source_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsSourcePortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_min"],
                    ),
                ),
            )])
        ```

        ## Import

        CaptureFilters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/captureFilter:CaptureFilter test_capture_filter "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CaptureFilterVtapCaptureFilterRuleArgs']]]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaptureFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Capture Filter resource in Oracle Cloud Infrastructure Core service.

        Creates a virtual test access point (VTAP) capture filter in the specified compartment.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains
        the VTAP. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VTAP, otherwise a default is provided.
        It does not have to be unique, and you can change it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_capture_filter = oci.core.CaptureFilter("testCaptureFilter",
            compartment_id=var["compartment_id"],
            filter_type=var["capture_filter_filter_type"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["capture_filter_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            vtap_capture_filter_rules=[oci.core.CaptureFilterVtapCaptureFilterRuleArgs(
                traffic_direction=var["capture_filter_vtap_capture_filter_rules_traffic_direction"],
                destination_cidr=var["capture_filter_vtap_capture_filter_rules_destination_cidr"],
                icmp_options=oci.core.CaptureFilterVtapCaptureFilterRuleIcmpOptionsArgs(
                    type=var["capture_filter_vtap_capture_filter_rules_icmp_options_type"],
                    code=var["capture_filter_vtap_capture_filter_rules_icmp_options_code"],
                ),
                protocol=var["capture_filter_vtap_capture_filter_rules_protocol"],
                rule_action=var["capture_filter_vtap_capture_filter_rules_rule_action"],
                source_cidr=var["capture_filter_vtap_capture_filter_rules_source_cidr"],
                tcp_options=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsArgs(
                    destination_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsDestinationPortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_tcp_options_destination_port_range_min"],
                    ),
                    source_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleTcpOptionsSourcePortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_tcp_options_source_port_range_min"],
                    ),
                ),
                udp_options=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsArgs(
                    destination_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsDestinationPortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_udp_options_destination_port_range_min"],
                    ),
                    source_port_range=oci.core.CaptureFilterVtapCaptureFilterRuleUdpOptionsSourcePortRangeArgs(
                        max=var["capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_max"],
                        min=var["capture_filter_vtap_capture_filter_rules_udp_options_source_port_range_min"],
                    ),
                ),
            )])
        ```

        ## Import

        CaptureFilters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/captureFilter:CaptureFilter test_capture_filter "id"
        ```

        :param str resource_name: The name of the resource.
        :param CaptureFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaptureFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CaptureFilterVtapCaptureFilterRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaptureFilterArgs.__new__(CaptureFilterArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if filter_type is None and not opts.urn:
                raise TypeError("Missing required property 'filter_type'")
            __props__.__dict__["filter_type"] = filter_type
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["vtap_capture_filter_rules"] = vtap_capture_filter_rules
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(CaptureFilter, __self__).__init__(
            'oci:Core/captureFilter:CaptureFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            filter_type: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            vtap_capture_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CaptureFilterVtapCaptureFilterRuleArgs']]]]] = None) -> 'CaptureFilter':
        """
        Get an existing CaptureFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] filter_type: Indicates which service will use this capture filter
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] state: The capture filter's current administrative state.
        :param pulumi.Input[str] time_created: The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CaptureFilterVtapCaptureFilterRuleArgs']]]] vtap_capture_filter_rules: (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaptureFilterState.__new__(_CaptureFilterState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filter_type"] = filter_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vtap_capture_filter_rules"] = vtap_capture_filter_rules
        return CaptureFilter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Output[str]:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The capture filter's current administrative state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> pulumi.Output[Sequence['outputs.CaptureFilterVtapCaptureFilterRule']]:
        """
        (Updatable) The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")

