# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MigrationArgs', 'Migration']

@pulumi.input_type
class MigrationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 source_database_connection_id: pulumi.Input[str],
                 target_database_connection_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 advisor_settings: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 csv_text: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']] = None,
                 datapump_settings: Optional[pulumi.Input['MigrationDatapumpSettingsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dump_transfer_details: Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 golden_gate_details: Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']] = None,
                 golden_gate_service_details: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input['MigrationVaultDetailsArgs']] = None):
        """
        The set of arguments for constructing a Migration resource.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the Source Database Connection.
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the Target Database Connection.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        :param pulumi.Input['MigrationAdvisorSettingsArgs'] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] agent_id: (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        :param pulumi.Input[str] csv_text: Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        :param pulumi.Input['MigrationDataTransferMediumDetailsArgs'] data_transfer_medium_details: (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        :param pulumi.Input['MigrationDatapumpSettingsArgs'] datapump_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration Display Name
        :param pulumi.Input['MigrationDumpTransferDetailsArgs'] dump_transfer_details: (Updatable) Optional additional properties for dump transfer.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]] exclude_objects: (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['MigrationGoldenGateDetailsArgs'] golden_gate_details: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsArgs'] golden_gate_service_details: (Updatable) Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]] include_objects: (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        :param pulumi.Input['MigrationVaultDetailsArgs'] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "source_database_connection_id", source_database_connection_id)
        pulumi.set(__self__, "target_database_connection_id", target_database_connection_id)
        pulumi.set(__self__, "type", type)
        if advisor_settings is not None:
            pulumi.set(__self__, "advisor_settings", advisor_settings)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if csv_text is not None:
            pulumi.set(__self__, "csv_text", csv_text)
        if data_transfer_medium_details is not None:
            pulumi.set(__self__, "data_transfer_medium_details", data_transfer_medium_details)
        if datapump_settings is not None:
            pulumi.set(__self__, "datapump_settings", datapump_settings)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dump_transfer_details is not None:
            pulumi.set(__self__, "dump_transfer_details", dump_transfer_details)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if golden_gate_details is not None:
            pulumi.set(__self__, "golden_gate_details", golden_gate_details)
        if golden_gate_service_details is not None:
            pulumi.set(__self__, "golden_gate_service_details", golden_gate_service_details)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if source_container_database_connection_id is not None:
            pulumi.set(__self__, "source_container_database_connection_id", source_container_database_connection_id)
        if vault_details is not None:
            pulumi.set(__self__, "vault_details", vault_details)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the Source Database Connection.
        """
        return pulumi.get(self, "source_database_connection_id")

    @source_database_connection_id.setter
    def source_database_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_database_connection_id", value)

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the Target Database Connection.
        """
        return pulumi.get(self, "target_database_connection_id")

    @target_database_connection_id.setter
    def target_database_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_database_connection_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @advisor_settings.setter
    def advisor_settings(self, value: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]):
        pulumi.set(self, "advisor_settings", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="csvText")
    def csv_text(self) -> Optional[pulumi.Input[str]]:
        """
        Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        """
        return pulumi.get(self, "csv_text")

    @csv_text.setter
    def csv_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_text", value)

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]:
        """
        (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @data_transfer_medium_details.setter
    def data_transfer_medium_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]):
        pulumi.set(self, "data_transfer_medium_details", value)

    @property
    @pulumi.getter(name="datapumpSettings")
    def datapump_settings(self) -> Optional[pulumi.Input['MigrationDatapumpSettingsArgs']]:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "datapump_settings")

    @datapump_settings.setter
    def datapump_settings(self, value: Optional[pulumi.Input['MigrationDatapumpSettingsArgs']]):
        pulumi.set(self, "datapump_settings", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dumpTransferDetails")
    def dump_transfer_details(self) -> Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer.
        """
        return pulumi.get(self, "dump_transfer_details")

    @dump_transfer_details.setter
    def dump_transfer_details(self, value: Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']]):
        pulumi.set(self, "dump_transfer_details", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]:
        """
        (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="goldenGateDetails")
    def golden_gate_details(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        """
        return pulumi.get(self, "golden_gate_details")

    @golden_gate_details.setter
    def golden_gate_details(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']]):
        pulumi.set(self, "golden_gate_details", value)

    @property
    @pulumi.getter(name="goldenGateServiceDetails")
    def golden_gate_service_details(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "golden_gate_service_details")

    @golden_gate_service_details.setter
    def golden_gate_service_details(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']]):
        pulumi.set(self, "golden_gate_service_details", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]:
        """
        (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @source_container_database_connection_id.setter
    def source_container_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_container_database_connection_id", value)

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> Optional[pulumi.Input['MigrationVaultDetailsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @vault_details.setter
    def vault_details(self, value: Optional[pulumi.Input['MigrationVaultDetailsArgs']]):
        pulumi.set(self, "vault_details", value)


@pulumi.input_type
class _MigrationState:
    def __init__(__self__, *,
                 advisor_settings: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 credentials_secret_id: Optional[pulumi.Input[str]] = None,
                 csv_text: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']] = None,
                 datapump_settings: Optional[pulumi.Input['MigrationDatapumpSettingsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dump_transfer_details: Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]] = None,
                 executing_job_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 golden_gate_details: Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']] = None,
                 golden_gate_service_details: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_migration: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input['MigrationVaultDetailsArgs']] = None,
                 wait_after: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Migration resources.
        :param pulumi.Input['MigrationAdvisorSettingsArgs'] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] agent_id: (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        :param pulumi.Input[str] csv_text: Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        :param pulumi.Input['MigrationDataTransferMediumDetailsArgs'] data_transfer_medium_details: (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        :param pulumi.Input['MigrationDatapumpSettingsArgs'] datapump_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration Display Name
        :param pulumi.Input['MigrationDumpTransferDetailsArgs'] dump_transfer_details: (Updatable) Optional additional properties for dump transfer.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]] exclude_objects: (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[str] executing_job_id: OCID of the current ODMS Job in execution for the Migration, if any.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['MigrationGoldenGateDetailsArgs'] golden_gate_details: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsArgs'] golden_gate_service_details: (Updatable) Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]] include_objects: (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[str] lifecycle_details: Additional status related to the execution and current state of the Migration.
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the Source Database Connection.
        :param pulumi.Input[str] state: The current state of the Migration resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the Target Database Connection.
        :param pulumi.Input[str] time_created: The time the Migration was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_last_migration: The time of last Migration. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time of the last Migration details update. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        :param pulumi.Input['MigrationVaultDetailsArgs'] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        :param pulumi.Input[str] wait_after: Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        if advisor_settings is not None:
            pulumi.set(__self__, "advisor_settings", advisor_settings)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if credentials_secret_id is not None:
            pulumi.set(__self__, "credentials_secret_id", credentials_secret_id)
        if csv_text is not None:
            pulumi.set(__self__, "csv_text", csv_text)
        if data_transfer_medium_details is not None:
            pulumi.set(__self__, "data_transfer_medium_details", data_transfer_medium_details)
        if datapump_settings is not None:
            pulumi.set(__self__, "datapump_settings", datapump_settings)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dump_transfer_details is not None:
            pulumi.set(__self__, "dump_transfer_details", dump_transfer_details)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if executing_job_id is not None:
            pulumi.set(__self__, "executing_job_id", executing_job_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if golden_gate_details is not None:
            pulumi.set(__self__, "golden_gate_details", golden_gate_details)
        if golden_gate_service_details is not None:
            pulumi.set(__self__, "golden_gate_service_details", golden_gate_service_details)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if source_container_database_connection_id is not None:
            pulumi.set(__self__, "source_container_database_connection_id", source_container_database_connection_id)
        if source_database_connection_id is not None:
            pulumi.set(__self__, "source_database_connection_id", source_database_connection_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_database_connection_id is not None:
            pulumi.set(__self__, "target_database_connection_id", target_database_connection_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_migration is not None:
            pulumi.set(__self__, "time_last_migration", time_last_migration)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vault_details is not None:
            pulumi.set(__self__, "vault_details", vault_details)
        if wait_after is not None:
            pulumi.set(__self__, "wait_after", wait_after)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @advisor_settings.setter
    def advisor_settings(self, value: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]):
        pulumi.set(self, "advisor_settings", value)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @credentials_secret_id.setter
    def credentials_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_secret_id", value)

    @property
    @pulumi.getter(name="csvText")
    def csv_text(self) -> Optional[pulumi.Input[str]]:
        """
        Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        """
        return pulumi.get(self, "csv_text")

    @csv_text.setter
    def csv_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_text", value)

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]:
        """
        (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @data_transfer_medium_details.setter
    def data_transfer_medium_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]):
        pulumi.set(self, "data_transfer_medium_details", value)

    @property
    @pulumi.getter(name="datapumpSettings")
    def datapump_settings(self) -> Optional[pulumi.Input['MigrationDatapumpSettingsArgs']]:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "datapump_settings")

    @datapump_settings.setter
    def datapump_settings(self, value: Optional[pulumi.Input['MigrationDatapumpSettingsArgs']]):
        pulumi.set(self, "datapump_settings", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dumpTransferDetails")
    def dump_transfer_details(self) -> Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer.
        """
        return pulumi.get(self, "dump_transfer_details")

    @dump_transfer_details.setter
    def dump_transfer_details(self, value: Optional[pulumi.Input['MigrationDumpTransferDetailsArgs']]):
        pulumi.set(self, "dump_transfer_details", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]:
        """
        (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the current ODMS Job in execution for the Migration, if any.
        """
        return pulumi.get(self, "executing_job_id")

    @executing_job_id.setter
    def executing_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executing_job_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="goldenGateDetails")
    def golden_gate_details(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        """
        return pulumi.get(self, "golden_gate_details")

    @golden_gate_details.setter
    def golden_gate_details(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsArgs']]):
        pulumi.set(self, "golden_gate_details", value)

    @property
    @pulumi.getter(name="goldenGateServiceDetails")
    def golden_gate_service_details(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "golden_gate_service_details")

    @golden_gate_service_details.setter
    def golden_gate_service_details(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsArgs']]):
        pulumi.set(self, "golden_gate_service_details", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]:
        """
        (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional status related to the execution and current state of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @source_container_database_connection_id.setter
    def source_container_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_container_database_connection_id", value)

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Source Database Connection.
        """
        return pulumi.get(self, "source_database_connection_id")

    @source_database_connection_id.setter
    def source_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_database_connection_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Migration resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Target Database Connection.
        """
        return pulumi.get(self, "target_database_connection_id")

    @target_database_connection_id.setter
    def target_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_connection_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Migration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> Optional[pulumi.Input[str]]:
        """
        The time of last Migration. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_migration")

    @time_last_migration.setter
    def time_last_migration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_migration", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the last Migration details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> Optional[pulumi.Input['MigrationVaultDetailsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @vault_details.setter
    def vault_details(self, value: Optional[pulumi.Input['MigrationVaultDetailsArgs']]):
        pulumi.set(self, "vault_details", value)

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        return pulumi.get(self, "wait_after")

    @wait_after.setter
    def wait_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_after", value)


class Migration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advisor_settings: Optional[pulumi.Input[pulumi.InputType['MigrationAdvisorSettingsArgs']]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 csv_text: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input[pulumi.InputType['MigrationDataTransferMediumDetailsArgs']]] = None,
                 datapump_settings: Optional[pulumi.Input[pulumi.InputType['MigrationDatapumpSettingsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dump_transfer_details: Optional[pulumi.Input[pulumi.InputType['MigrationDumpTransferDetailsArgs']]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationExcludeObjectArgs']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 golden_gate_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateDetailsArgs']]] = None,
                 golden_gate_service_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateServiceDetailsArgs']]] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationIncludeObjectArgs']]]]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input[pulumi.InputType['MigrationVaultDetailsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Migration resource in Oracle Cloud Infrastructure Database Migration service.

        Create a Migration resource that contains all the details to perform the
        database migration operation, such as source and destination database
        details, credentials, etc.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration = oci.database_migration.Migration("testMigration",
            compartment_id=var["compartment_id"],
            source_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            target_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            type=var["migration_type"],
            advisor_settings=oci.database_migration.MigrationAdvisorSettingsArgs(
                is_ignore_errors=var["migration_advisor_settings_is_ignore_errors"],
                is_skip_advisor=var["migration_advisor_settings_is_skip_advisor"],
            ),
            agent_id=oci_database_migration_agent["test_agent"]["id"],
            csv_text=var["migration_csv_text"],
            data_transfer_medium_details=oci.database_migration.MigrationDataTransferMediumDetailsArgs(
                database_link_details=oci.database_migration.MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs(
                    name=var["migration_data_transfer_medium_details_database_link_details_name"],
                    wallet_bucket=oci.database_migration.MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs(
                        bucket=var["migration_data_transfer_medium_details_database_link_details_wallet_bucket_bucket"],
                        namespace=var["migration_data_transfer_medium_details_database_link_details_wallet_bucket_namespace"],
                    ),
                ),
                object_storage_details=oci.database_migration.MigrationDataTransferMediumDetailsObjectStorageDetailsArgs(
                    bucket=var["migration_data_transfer_medium_details_object_storage_details_bucket"],
                    namespace=var["migration_data_transfer_medium_details_object_storage_details_namespace"],
                ),
            ),
            datapump_settings=oci.database_migration.MigrationDatapumpSettingsArgs(
                data_pump_parameters=oci.database_migration.MigrationDatapumpSettingsDataPumpParametersArgs(
                    estimate=var["migration_datapump_settings_data_pump_parameters_estimate"],
                    exclude_parameters=var["migration_datapump_settings_data_pump_parameters_exclude_parameters"],
                    export_parallelism_degree=var["migration_datapump_settings_data_pump_parameters_export_parallelism_degree"],
                    import_parallelism_degree=var["migration_datapump_settings_data_pump_parameters_import_parallelism_degree"],
                    is_cluster=var["migration_datapump_settings_data_pump_parameters_is_cluster"],
                    table_exists_action=var["migration_datapump_settings_data_pump_parameters_table_exists_action"],
                ),
                export_directory_object=oci.database_migration.MigrationDatapumpSettingsExportDirectoryObjectArgs(
                    name=var["migration_datapump_settings_export_directory_object_name"],
                    path=var["migration_datapump_settings_export_directory_object_path"],
                ),
                import_directory_object=oci.database_migration.MigrationDatapumpSettingsImportDirectoryObjectArgs(
                    name=var["migration_datapump_settings_import_directory_object_name"],
                    path=var["migration_datapump_settings_import_directory_object_path"],
                ),
                job_mode=var["migration_datapump_settings_job_mode"],
                metadata_remaps=[oci.database_migration.MigrationDatapumpSettingsMetadataRemapArgs(
                    new_value=var["migration_datapump_settings_metadata_remaps_new_value"],
                    old_value=var["migration_datapump_settings_metadata_remaps_old_value"],
                    type=var["migration_datapump_settings_metadata_remaps_type"],
                )],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["migration_display_name"],
            dump_transfer_details=oci.database_migration.MigrationDumpTransferDetailsArgs(
                source=oci.database_migration.MigrationDumpTransferDetailsSourceArgs(
                    kind=var["migration_dump_transfer_details_source_kind"],
                    oci_home=var["migration_dump_transfer_details_source_oci_home"],
                    wallet_location=var["migration_dump_transfer_details_source_wallet_location"],
                ),
                target=oci.database_migration.MigrationDumpTransferDetailsTargetArgs(
                    kind=var["migration_dump_transfer_details_target_kind"],
                    oci_home=var["migration_dump_transfer_details_target_oci_home"],
                    wallet_location=var["migration_dump_transfer_details_target_wallet_location"],
                ),
            ),
            exclude_objects=[oci.database_migration.MigrationExcludeObjectArgs(
                object=var["migration_exclude_objects_object"],
                owner=var["migration_exclude_objects_owner"],
                is_omit_excluded_table_from_replication=var["migration_exclude_objects_is_omit_excluded_table_from_replication"],
                type=var["migration_exclude_objects_type"],
            )],
            freeform_tags={
                "bar-key": "value",
            },
            golden_gate_details=oci.database_migration.MigrationGoldenGateDetailsArgs(
                hub=oci.database_migration.MigrationGoldenGateDetailsHubArgs(
                    rest_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubRestAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_rest_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_rest_admin_credentials_username"],
                    ),
                    url=var["migration_golden_gate_details_hub_url"],
                    compute_id=oci_database_migration_compute["test_compute"]["id"],
                    source_container_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_source_container_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_source_container_db_admin_credentials_username"],
                    ),
                    source_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_source_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_source_db_admin_credentials_username"],
                    ),
                    source_microservices_deployment_name=oci_apigateway_deployment["test_deployment"]["name"],
                    target_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_target_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_target_db_admin_credentials_username"],
                    ),
                    target_microservices_deployment_name=oci_apigateway_deployment["test_deployment"]["name"],
                ),
                settings=oci.database_migration.MigrationGoldenGateDetailsSettingsArgs(
                    acceptable_lag=var["migration_golden_gate_details_settings_acceptable_lag"],
                    extract=oci.database_migration.MigrationGoldenGateDetailsSettingsExtractArgs(
                        long_trans_duration=var["migration_golden_gate_details_settings_extract_long_trans_duration"],
                        performance_profile=var["migration_golden_gate_details_settings_extract_performance_profile"],
                    ),
                    replicat=oci.database_migration.MigrationGoldenGateDetailsSettingsReplicatArgs(
                        map_parallelism=var["migration_golden_gate_details_settings_replicat_map_parallelism"],
                        max_apply_parallelism=var["migration_golden_gate_details_settings_replicat_max_apply_parallelism"],
                        min_apply_parallelism=var["migration_golden_gate_details_settings_replicat_min_apply_parallelism"],
                    ),
                ),
            ),
            golden_gate_service_details=oci.database_migration.MigrationGoldenGateServiceDetailsArgs(
                settings=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsArgs(
                    acceptable_lag=var["migration_golden_gate_service_details_settings_acceptable_lag"],
                    extract=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsExtractArgs(
                        long_trans_duration=var["migration_golden_gate_service_details_settings_extract_long_trans_duration"],
                        performance_profile=var["migration_golden_gate_service_details_settings_extract_performance_profile"],
                    ),
                    replicat=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsReplicatArgs(
                        map_parallelism=var["migration_golden_gate_service_details_settings_replicat_map_parallelism"],
                        max_apply_parallelism=var["migration_golden_gate_service_details_settings_replicat_max_apply_parallelism"],
                        min_apply_parallelism=var["migration_golden_gate_service_details_settings_replicat_min_apply_parallelism"],
                    ),
                ),
                source_container_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_source_container_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_source_container_db_credentials_username"],
                ),
                source_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_source_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_source_db_credentials_username"],
                ),
                target_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_target_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_target_db_credentials_username"],
                ),
            ),
            include_objects=[oci.database_migration.MigrationIncludeObjectArgs(
                object=var["migration_include_objects_object"],
                owner=var["migration_include_objects_owner"],
                is_omit_excluded_table_from_replication=var["migration_include_objects_is_omit_excluded_table_from_replication"],
                type=var["migration_include_objects_type"],
            )],
            source_container_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            vault_details=oci.database_migration.MigrationVaultDetailsArgs(
                compartment_id=var["compartment_id"],
                key_id=oci_kms_key["test_key"]["id"],
                vault_id=oci_kms_vault["test_vault"]["id"],
            ))
        ```

        ## Import

        Migrations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseMigration/migration:Migration test_migration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MigrationAdvisorSettingsArgs']] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] agent_id: (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] csv_text: Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        :param pulumi.Input[pulumi.InputType['MigrationDataTransferMediumDetailsArgs']] data_transfer_medium_details: (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        :param pulumi.Input[pulumi.InputType['MigrationDatapumpSettingsArgs']] datapump_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration Display Name
        :param pulumi.Input[pulumi.InputType['MigrationDumpTransferDetailsArgs']] dump_transfer_details: (Updatable) Optional additional properties for dump transfer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationExcludeObjectArgs']]]] exclude_objects: (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['MigrationGoldenGateDetailsArgs']] golden_gate_details: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param pulumi.Input[pulumi.InputType['MigrationGoldenGateServiceDetailsArgs']] golden_gate_service_details: (Updatable) Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationIncludeObjectArgs']]]] include_objects: (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the Source Database Connection.
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the Target Database Connection.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        :param pulumi.Input[pulumi.InputType['MigrationVaultDetailsArgs']] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Migration resource in Oracle Cloud Infrastructure Database Migration service.

        Create a Migration resource that contains all the details to perform the
        database migration operation, such as source and destination database
        details, credentials, etc.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration = oci.database_migration.Migration("testMigration",
            compartment_id=var["compartment_id"],
            source_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            target_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            type=var["migration_type"],
            advisor_settings=oci.database_migration.MigrationAdvisorSettingsArgs(
                is_ignore_errors=var["migration_advisor_settings_is_ignore_errors"],
                is_skip_advisor=var["migration_advisor_settings_is_skip_advisor"],
            ),
            agent_id=oci_database_migration_agent["test_agent"]["id"],
            csv_text=var["migration_csv_text"],
            data_transfer_medium_details=oci.database_migration.MigrationDataTransferMediumDetailsArgs(
                database_link_details=oci.database_migration.MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs(
                    name=var["migration_data_transfer_medium_details_database_link_details_name"],
                    wallet_bucket=oci.database_migration.MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs(
                        bucket=var["migration_data_transfer_medium_details_database_link_details_wallet_bucket_bucket"],
                        namespace=var["migration_data_transfer_medium_details_database_link_details_wallet_bucket_namespace"],
                    ),
                ),
                object_storage_details=oci.database_migration.MigrationDataTransferMediumDetailsObjectStorageDetailsArgs(
                    bucket=var["migration_data_transfer_medium_details_object_storage_details_bucket"],
                    namespace=var["migration_data_transfer_medium_details_object_storage_details_namespace"],
                ),
            ),
            datapump_settings=oci.database_migration.MigrationDatapumpSettingsArgs(
                data_pump_parameters=oci.database_migration.MigrationDatapumpSettingsDataPumpParametersArgs(
                    estimate=var["migration_datapump_settings_data_pump_parameters_estimate"],
                    exclude_parameters=var["migration_datapump_settings_data_pump_parameters_exclude_parameters"],
                    export_parallelism_degree=var["migration_datapump_settings_data_pump_parameters_export_parallelism_degree"],
                    import_parallelism_degree=var["migration_datapump_settings_data_pump_parameters_import_parallelism_degree"],
                    is_cluster=var["migration_datapump_settings_data_pump_parameters_is_cluster"],
                    table_exists_action=var["migration_datapump_settings_data_pump_parameters_table_exists_action"],
                ),
                export_directory_object=oci.database_migration.MigrationDatapumpSettingsExportDirectoryObjectArgs(
                    name=var["migration_datapump_settings_export_directory_object_name"],
                    path=var["migration_datapump_settings_export_directory_object_path"],
                ),
                import_directory_object=oci.database_migration.MigrationDatapumpSettingsImportDirectoryObjectArgs(
                    name=var["migration_datapump_settings_import_directory_object_name"],
                    path=var["migration_datapump_settings_import_directory_object_path"],
                ),
                job_mode=var["migration_datapump_settings_job_mode"],
                metadata_remaps=[oci.database_migration.MigrationDatapumpSettingsMetadataRemapArgs(
                    new_value=var["migration_datapump_settings_metadata_remaps_new_value"],
                    old_value=var["migration_datapump_settings_metadata_remaps_old_value"],
                    type=var["migration_datapump_settings_metadata_remaps_type"],
                )],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["migration_display_name"],
            dump_transfer_details=oci.database_migration.MigrationDumpTransferDetailsArgs(
                source=oci.database_migration.MigrationDumpTransferDetailsSourceArgs(
                    kind=var["migration_dump_transfer_details_source_kind"],
                    oci_home=var["migration_dump_transfer_details_source_oci_home"],
                    wallet_location=var["migration_dump_transfer_details_source_wallet_location"],
                ),
                target=oci.database_migration.MigrationDumpTransferDetailsTargetArgs(
                    kind=var["migration_dump_transfer_details_target_kind"],
                    oci_home=var["migration_dump_transfer_details_target_oci_home"],
                    wallet_location=var["migration_dump_transfer_details_target_wallet_location"],
                ),
            ),
            exclude_objects=[oci.database_migration.MigrationExcludeObjectArgs(
                object=var["migration_exclude_objects_object"],
                owner=var["migration_exclude_objects_owner"],
                is_omit_excluded_table_from_replication=var["migration_exclude_objects_is_omit_excluded_table_from_replication"],
                type=var["migration_exclude_objects_type"],
            )],
            freeform_tags={
                "bar-key": "value",
            },
            golden_gate_details=oci.database_migration.MigrationGoldenGateDetailsArgs(
                hub=oci.database_migration.MigrationGoldenGateDetailsHubArgs(
                    rest_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubRestAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_rest_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_rest_admin_credentials_username"],
                    ),
                    url=var["migration_golden_gate_details_hub_url"],
                    compute_id=oci_database_migration_compute["test_compute"]["id"],
                    source_container_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_source_container_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_source_container_db_admin_credentials_username"],
                    ),
                    source_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_source_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_source_db_admin_credentials_username"],
                    ),
                    source_microservices_deployment_name=oci_apigateway_deployment["test_deployment"]["name"],
                    target_db_admin_credentials=oci.database_migration.MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs(
                        password=var["migration_golden_gate_details_hub_target_db_admin_credentials_password"],
                        username=var["migration_golden_gate_details_hub_target_db_admin_credentials_username"],
                    ),
                    target_microservices_deployment_name=oci_apigateway_deployment["test_deployment"]["name"],
                ),
                settings=oci.database_migration.MigrationGoldenGateDetailsSettingsArgs(
                    acceptable_lag=var["migration_golden_gate_details_settings_acceptable_lag"],
                    extract=oci.database_migration.MigrationGoldenGateDetailsSettingsExtractArgs(
                        long_trans_duration=var["migration_golden_gate_details_settings_extract_long_trans_duration"],
                        performance_profile=var["migration_golden_gate_details_settings_extract_performance_profile"],
                    ),
                    replicat=oci.database_migration.MigrationGoldenGateDetailsSettingsReplicatArgs(
                        map_parallelism=var["migration_golden_gate_details_settings_replicat_map_parallelism"],
                        max_apply_parallelism=var["migration_golden_gate_details_settings_replicat_max_apply_parallelism"],
                        min_apply_parallelism=var["migration_golden_gate_details_settings_replicat_min_apply_parallelism"],
                    ),
                ),
            ),
            golden_gate_service_details=oci.database_migration.MigrationGoldenGateServiceDetailsArgs(
                settings=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsArgs(
                    acceptable_lag=var["migration_golden_gate_service_details_settings_acceptable_lag"],
                    extract=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsExtractArgs(
                        long_trans_duration=var["migration_golden_gate_service_details_settings_extract_long_trans_duration"],
                        performance_profile=var["migration_golden_gate_service_details_settings_extract_performance_profile"],
                    ),
                    replicat=oci.database_migration.MigrationGoldenGateServiceDetailsSettingsReplicatArgs(
                        map_parallelism=var["migration_golden_gate_service_details_settings_replicat_map_parallelism"],
                        max_apply_parallelism=var["migration_golden_gate_service_details_settings_replicat_max_apply_parallelism"],
                        min_apply_parallelism=var["migration_golden_gate_service_details_settings_replicat_min_apply_parallelism"],
                    ),
                ),
                source_container_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_source_container_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_source_container_db_credentials_username"],
                ),
                source_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_source_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_source_db_credentials_username"],
                ),
                target_db_credentials=oci.database_migration.MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs(
                    password=var["migration_golden_gate_service_details_target_db_credentials_password"],
                    username=var["migration_golden_gate_service_details_target_db_credentials_username"],
                ),
            ),
            include_objects=[oci.database_migration.MigrationIncludeObjectArgs(
                object=var["migration_include_objects_object"],
                owner=var["migration_include_objects_owner"],
                is_omit_excluded_table_from_replication=var["migration_include_objects_is_omit_excluded_table_from_replication"],
                type=var["migration_include_objects_type"],
            )],
            source_container_database_connection_id=oci_database_migration_connection["test_connection"]["id"],
            vault_details=oci.database_migration.MigrationVaultDetailsArgs(
                compartment_id=var["compartment_id"],
                key_id=oci_kms_key["test_key"]["id"],
                vault_id=oci_kms_vault["test_vault"]["id"],
            ))
        ```

        ## Import

        Migrations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseMigration/migration:Migration test_migration "id"
        ```

        :param str resource_name: The name of the resource.
        :param MigrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advisor_settings: Optional[pulumi.Input[pulumi.InputType['MigrationAdvisorSettingsArgs']]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 csv_text: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input[pulumi.InputType['MigrationDataTransferMediumDetailsArgs']]] = None,
                 datapump_settings: Optional[pulumi.Input[pulumi.InputType['MigrationDatapumpSettingsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dump_transfer_details: Optional[pulumi.Input[pulumi.InputType['MigrationDumpTransferDetailsArgs']]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationExcludeObjectArgs']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 golden_gate_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateDetailsArgs']]] = None,
                 golden_gate_service_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateServiceDetailsArgs']]] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationIncludeObjectArgs']]]]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input[pulumi.InputType['MigrationVaultDetailsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationArgs.__new__(MigrationArgs)

            __props__.__dict__["advisor_settings"] = advisor_settings
            __props__.__dict__["agent_id"] = agent_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["csv_text"] = csv_text
            __props__.__dict__["data_transfer_medium_details"] = data_transfer_medium_details
            __props__.__dict__["datapump_settings"] = datapump_settings
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dump_transfer_details"] = dump_transfer_details
            __props__.__dict__["exclude_objects"] = exclude_objects
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["golden_gate_details"] = golden_gate_details
            __props__.__dict__["golden_gate_service_details"] = golden_gate_service_details
            __props__.__dict__["include_objects"] = include_objects
            __props__.__dict__["source_container_database_connection_id"] = source_container_database_connection_id
            if source_database_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_database_connection_id'")
            __props__.__dict__["source_database_connection_id"] = source_database_connection_id
            if target_database_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_database_connection_id'")
            __props__.__dict__["target_database_connection_id"] = target_database_connection_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vault_details"] = vault_details
            __props__.__dict__["credentials_secret_id"] = None
            __props__.__dict__["executing_job_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_migration"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["wait_after"] = None
        super(Migration, __self__).__init__(
            'oci:DatabaseMigration/migration:Migration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advisor_settings: Optional[pulumi.Input[pulumi.InputType['MigrationAdvisorSettingsArgs']]] = None,
            agent_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            credentials_secret_id: Optional[pulumi.Input[str]] = None,
            csv_text: Optional[pulumi.Input[str]] = None,
            data_transfer_medium_details: Optional[pulumi.Input[pulumi.InputType['MigrationDataTransferMediumDetailsArgs']]] = None,
            datapump_settings: Optional[pulumi.Input[pulumi.InputType['MigrationDatapumpSettingsArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dump_transfer_details: Optional[pulumi.Input[pulumi.InputType['MigrationDumpTransferDetailsArgs']]] = None,
            exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationExcludeObjectArgs']]]]] = None,
            executing_job_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            golden_gate_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateDetailsArgs']]] = None,
            golden_gate_service_details: Optional[pulumi.Input[pulumi.InputType['MigrationGoldenGateServiceDetailsArgs']]] = None,
            include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationIncludeObjectArgs']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
            source_database_connection_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_database_connection_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_migration: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vault_details: Optional[pulumi.Input[pulumi.InputType['MigrationVaultDetailsArgs']]] = None,
            wait_after: Optional[pulumi.Input[str]] = None) -> 'Migration':
        """
        Get an existing Migration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MigrationAdvisorSettingsArgs']] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] agent_id: (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        :param pulumi.Input[str] csv_text: Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        :param pulumi.Input[pulumi.InputType['MigrationDataTransferMediumDetailsArgs']] data_transfer_medium_details: (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        :param pulumi.Input[pulumi.InputType['MigrationDatapumpSettingsArgs']] datapump_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration Display Name
        :param pulumi.Input[pulumi.InputType['MigrationDumpTransferDetailsArgs']] dump_transfer_details: (Updatable) Optional additional properties for dump transfer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationExcludeObjectArgs']]]] exclude_objects: (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[str] executing_job_id: OCID of the current ODMS Job in execution for the Migration, if any.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['MigrationGoldenGateDetailsArgs']] golden_gate_details: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param pulumi.Input[pulumi.InputType['MigrationGoldenGateServiceDetailsArgs']] golden_gate_service_details: (Updatable) Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationIncludeObjectArgs']]]] include_objects: (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[str] lifecycle_details: Additional status related to the execution and current state of the Migration.
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the Source Database Connection.
        :param pulumi.Input[str] state: The current state of the Migration resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the Target Database Connection.
        :param pulumi.Input[str] time_created: The time the Migration was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_last_migration: The time of last Migration. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time of the last Migration details update. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        :param pulumi.Input[pulumi.InputType['MigrationVaultDetailsArgs']] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        :param pulumi.Input[str] wait_after: Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationState.__new__(_MigrationState)

        __props__.__dict__["advisor_settings"] = advisor_settings
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["credentials_secret_id"] = credentials_secret_id
        __props__.__dict__["csv_text"] = csv_text
        __props__.__dict__["data_transfer_medium_details"] = data_transfer_medium_details
        __props__.__dict__["datapump_settings"] = datapump_settings
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dump_transfer_details"] = dump_transfer_details
        __props__.__dict__["exclude_objects"] = exclude_objects
        __props__.__dict__["executing_job_id"] = executing_job_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["golden_gate_details"] = golden_gate_details
        __props__.__dict__["golden_gate_service_details"] = golden_gate_service_details
        __props__.__dict__["include_objects"] = include_objects
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["source_container_database_connection_id"] = source_container_database_connection_id
        __props__.__dict__["source_database_connection_id"] = source_database_connection_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_database_connection_id"] = target_database_connection_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_migration"] = time_last_migration
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["vault_details"] = vault_details
        __props__.__dict__["wait_after"] = wait_after
        return Migration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> pulumi.Output['outputs.MigrationAdvisorSettings']:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the registered ODMS Agent. Only valid for Offline Logical Migrations.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> pulumi.Output[str]:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @property
    @pulumi.getter(name="csvText")
    def csv_text(self) -> pulumi.Output[str]:
        """
        Database objects to exclude/include from migration in CSV format. The excludeObjects and includeObjects fields will be ignored if this field is not null.
        """
        return pulumi.get(self, "csv_text")

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> pulumi.Output['outputs.MigrationDataTransferMediumDetails']:
        """
        (Updatable) Data Transfer Medium details for the Migration. If not specified, it will default to Database Link. Only one type of data transfer medium can be specified.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @property
    @pulumi.getter(name="datapumpSettings")
    def datapump_settings(self) -> pulumi.Output['outputs.MigrationDatapumpSettings']:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "datapump_settings")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Migration Display Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dumpTransferDetails")
    def dump_transfer_details(self) -> pulumi.Output['outputs.MigrationDumpTransferDetails']:
        """
        (Updatable) Optional additional properties for dump transfer.
        """
        return pulumi.get(self, "dump_transfer_details")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> pulumi.Output[Sequence['outputs.MigrationExcludeObject']]:
        """
        (Updatable) Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> pulumi.Output[str]:
        """
        OCID of the current ODMS Job in execution for the Migration, if any.
        """
        return pulumi.get(self, "executing_job_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="goldenGateDetails")
    def golden_gate_details(self) -> pulumi.Output['outputs.MigrationGoldenGateDetails']:
        """
        (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        """
        return pulumi.get(self, "golden_gate_details")

    @property
    @pulumi.getter(name="goldenGateServiceDetails")
    def golden_gate_service_details(self) -> pulumi.Output['outputs.MigrationGoldenGateServiceDetails']:
        """
        (Updatable) Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "golden_gate_service_details")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> pulumi.Output[Sequence['outputs.MigrationIncludeObject']]:
        """
        (Updatable) Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional status related to the execution and current state of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Source Container Database Connection. Only used for Online migrations. Only Connections of type Non-Autonomous can be used as source container databases.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Source Database Connection.
        """
        return pulumi.get(self, "source_database_connection_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Migration resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Target Database Connection.
        """
        return pulumi.get(self, "target_database_connection_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Migration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> pulumi.Output[str]:
        """
        The time of last Migration. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_migration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time of the last Migration details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> pulumi.Output['outputs.MigrationVaultDetails']:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> pulumi.Output[str]:
        """
        Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        return pulumi.get(self, "wait_after")

